/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.canvas_bundle_jsonpfunction=window.canvas_bundle_jsonpfunction||[]).push([[2],{125:function(e,a,t){"use strict";t.d(a,"b",(function(){return Oe})),t.d(a,"a",(function(){return Ie}));var s=t(3),n=t(55);const l={help:s.i18n.translate("xpack.canvas.functions.allHelpText",{defaultMessage:"Returns {BOOLEAN_TRUE} if all of the conditions are met. See also {anyFn}.",values:{anyFn:"`any`",BOOLEAN_TRUE:n.b}}),args:{condition:s.i18n.translate("xpack.canvas.functions.all.args.conditionHelpText",{defaultMessage:"The conditions to check."})}};var i=t(0);const r={help:s.i18n.translate("xpack.canvas.functions.alterColumnHelpText",{defaultMessage:"Converts between core types, including {list}, and {end}, and renames columns. See also {mapColumnFn}, {mathColumnFn}, and {staticColumnFn}.",values:{list:Object.values(i.p).slice(0,-1).map((e=>`\`${e}\``)).join(", "),end:`\`${Object.values(i.p).slice(-1)[0]}\``,mapColumnFn:"`mapColumn`",staticColumnFn:"`staticColumn`",mathColumnFn:"`mathColumn`"}}),args:{column:s.i18n.translate("xpack.canvas.functions.alterColumn.args.columnHelpText",{defaultMessage:"The name of the column to alter."}),name:s.i18n.translate("xpack.canvas.functions.alterColumn.args.nameHelpText",{defaultMessage:"The resultant column name. Leave blank to not rename."}),type:s.i18n.translate("xpack.canvas.functions.alterColumn.args.typeHelpText",{defaultMessage:"The type to convert the column to. Leave blank to not change the type."})}},o={columnNotFound:e=>new Error(s.i18n.translate("xpack.canvas.functions.alterColumn.columnNotFoundErrorMessage",{defaultMessage:"Column not found: '{column}'",values:{column:e}})),cannotConvertType:e=>new Error(s.i18n.translate("xpack.canvas.functions.alterColumn.cannotConvertTypeErrorMessage",{defaultMessage:"Cannot convert to '{type}'",values:{type:e}}))},c={help:s.i18n.translate("xpack.canvas.functions.anyHelpText",{defaultMessage:"Returns {BOOLEAN_TRUE} if at least one of the conditions is met. See also {all_fn}.",values:{all_fn:"`all`",BOOLEAN_TRUE:n.b}}),args:{condition:s.i18n.translate("xpack.canvas.functions.any.args.conditionHelpText",{defaultMessage:"The conditions to check."})}},u={help:s.i18n.translate("xpack.canvas.functions.asHelpText",{defaultMessage:"Creates a {DATATABLE} with a single value. See also {getCellFn}.",values:{DATATABLE:n.g,getCellFn:"`getCell`"}}),args:{name:s.i18n.translate("xpack.canvas.functions.as.args.nameHelpText",{defaultMessage:"The name to give the column."})}},p={help:s.i18n.translate("xpack.canvas.functions.assetHelpText",{defaultMessage:"Retrieves Canvas workpad asset objects to provide as argument values. Usually images."}),args:{id:s.i18n.translate("xpack.canvas.functions.asset.args.id",{defaultMessage:"The ID of the asset to retrieve."})}},g={invalidAssetId:e=>new Error(s.i18n.translate("xpack.canvas.functions.asset.invalidAssetId",{defaultMessage:"Could not get the asset by ID: '{assetId}'",values:{assetId:e},description:"This error occurs when there is no asset object associated with the given ID."}))};var d=t(66);const f={help:s.i18n.translate("xpack.canvas.functions.axisConfigHelpText",{defaultMessage:"Configures the axis of a visualization. Only used with {plotFn}.",values:{plotFn:"`plot`"}}),args:{max:s.i18n.translate("xpack.canvas.functions.axisConfig.args.maxHelpText",{defaultMessage:"The maximum value displayed in the axis. Must be a number, a date in milliseconds since epoch, or an {ISO8601} string.",values:{ISO8601:n.p}}),min:s.i18n.translate("xpack.canvas.functions.axisConfig.args.minHelpText",{defaultMessage:"The minimum value displayed in the axis. Must be a number, a date in milliseconds since epoch, or an {ISO8601} string.",values:{ISO8601:n.p}}),position:s.i18n.translate("xpack.canvas.functions.axisConfig.args.positionHelpText",{defaultMessage:"The position of the axis labels. For example, {list}, or {end}.",values:{list:Object.values(d.Position).slice(0,-1).map((e=>`\`"${e}"\``)).join(", "),end:`\`"${Object.values(d.Position).slice(-1)[0]}"\``}}),show:s.i18n.translate("xpack.canvas.functions.axisConfig.args.showHelpText",{defaultMessage:"Show the axis labels?"}),tickSize:s.i18n.translate("xpack.canvas.functions.axisConfig.args.tickSizeHelpText",{defaultMessage:"The increment size between each tick. Use for `number` axes only."})}},m={invalidPosition:e=>new Error(s.i18n.translate("xpack.canvas.functions.axisConfig.invalidPositionErrorMessage",{defaultMessage:"Invalid position: '{position}'",values:{position:e}})),invalidMinDateString:e=>new Error(s.i18n.translate("xpack.canvas.functions.axisConfig.invalidMinDateStringErrorMessage",{defaultMessage:"Invalid date string: '{min}'. 'min' must be a number, date in ms, or ISO8601 date string",values:{min:e}})),invalidMaxDateString:e=>new Error(s.i18n.translate("xpack.canvas.functions.axisConfig.invalidMaxPositionErrorMessage",{defaultMessage:"Invalid date string: '{max}'. 'max' must be a number, date in ms, or ISO8601 date string",values:{max:e}}))},v="`if`",x="`when`",h={help:s.i18n.translate("xpack.canvas.functions.caseHelpText",{defaultMessage:"Builds a {case}, including a condition and a result, to pass to the {switchFn} function.",values:{case:"`case`",switchFn:"`switch`"}}),args:{when:s.i18n.translate("xpack.canvas.functions.case.args.whenHelpText",{defaultMessage:"The value compared to the {CONTEXT} to see if they are equal. The {WHEN_ARG} argument is ignored when the {IF_ARG} argument is also specified.",values:{CONTEXT:n.d,IF_ARG:v,WHEN_ARG:x}}),if:s.i18n.translate("xpack.canvas.functions.case.args.ifHelpText",{defaultMessage:"This value indicates whether the condition is met. The {IF_ARG} argument overrides the {WHEN_ARG} argument when both are provided.",values:{IF_ARG:v,WHEN_ARG:x}}),then:s.i18n.translate("xpack.canvas.functions.case.args.thenHelpText",{defaultMessage:"The value returned if the condition is met."})}},T={help:s.i18n.translate("xpack.canvas.functions.clearHelpText",{defaultMessage:"Clears the {CONTEXT}, and returns {TYPE_NULL}.",values:{CONTEXT:n.d,TYPE_NULL:n.H}}),args:{}},M={help:s.i18n.translate("xpack.canvas.functions.columnsHelpText",{defaultMessage:"Includes or excludes columns from a {DATATABLE}. When both arguments are specified, the excluded columns will be removed first.",values:{DATATABLE:n.g}}),args:{include:s.i18n.translate("xpack.canvas.functions.columns.args.includeHelpText",{defaultMessage:"A comma-separated list of column names to keep in the {DATATABLE}.",values:{DATATABLE:n.g}}),exclude:s.i18n.translate("xpack.canvas.functions.columns.args.excludeHelpText",{defaultMessage:"A comma-separated list of column names to remove from the {DATATABLE}.",values:{DATATABLE:n.g}})}};var k=t(173);const y={help:s.i18n.translate("xpack.canvas.functions.compareHelpText",{defaultMessage:"Compares the {CONTEXT} to specified value to determine {BOOLEAN_TRUE} or {BOOLEAN_FALSE}. Usually used in combination with `{ifFn}` or `{caseFn}`. This only works with primitive types, such as {examples}. See also {eqFn}, {gtFn}, {gteFn}, {ltFn}, {lteFn}, {neqFn}",values:{CONTEXT:n.d,BOOLEAN_TRUE:n.b,BOOLEAN_FALSE:n.a,ifFn:"`if`",caseFn:"case",examples:[n.I,n.J,n.G,n.H].join(", "),eqFn:"`eq`",gtFn:"`gt`",gteFn:"`gte`",ltFn:"`lt`",lteFn:"`lte`",neqFn:"`neq`"}}),args:{op:s.i18n.translate("xpack.canvas.functions.compare.args.opHelpText",{defaultMessage:"The operator to use in the comparison: {eq} (equal to), {gt} (greater than), {gte} (greater than or equal to), {lt} (less than), {lte} (less than or equal to), {ne} or {neq} (not equal to).",values:{eq:`\`"${k.a.EQ}"\``,gt:`\`"${k.a.GT}"\``,gte:`\`"${k.a.GTE}"\``,lt:`\`"${k.a.LT}"\``,lte:`\`"${k.a.LTE}"\``,ne:`\`"${k.a.NE}"\``,neq:`\`"${k.a.NEQ}"\``}}),to:s.i18n.translate("xpack.canvas.functions.compare.args.toHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},b={invalidCompareOperator:(e,a)=>new Error(s.i18n.translate("xpack.canvas.functions.compare.invalidCompareOperatorErrorMessage",{defaultMessage:"Invalid compare operator: '{op}'. Use {ops}",values:{op:e,ops:a}}))},w={help:s.i18n.translate("xpack.canvas.functions.containerStyleHelpText",{defaultMessage:"Creates an object used for styling an element's container, including background, border, and opacity."}),args:{backgroundColor:s.i18n.translate("xpack.canvas.functions.containerStyle.args.backgroundColorHelpText",{defaultMessage:"A valid {CSS} background color.",values:{CSS:n.e}}),backgroundImage:s.i18n.translate("xpack.canvas.functions.containerStyle.args.backgroundImageHelpText",{defaultMessage:"A valid {CSS} background image.",values:{CSS:n.e}}),backgroundRepeat:s.i18n.translate("xpack.canvas.functions.containerStyle.args.backgroundRepeatHelpText",{defaultMessage:"A valid {CSS} background repeat.",values:{CSS:n.e}}),backgroundSize:s.i18n.translate("xpack.canvas.functions.containerStyle.args.backgroundSizeHelpText",{defaultMessage:"A valid {CSS} background size.",values:{CSS:n.e}}),border:s.i18n.translate("xpack.canvas.functions.containerStyle.args.borderHelpText",{defaultMessage:"A valid {CSS} border.",values:{CSS:n.e}}),borderRadius:s.i18n.translate("xpack.canvas.functions.containerStyle.args.borderRadiusHelpText",{defaultMessage:"The number of pixels to use when rounding the corners."}),opacity:s.i18n.translate("xpack.canvas.functions.containerStyle.args.opacityHelpText",{defaultMessage:"A number between 0 and 1 that represents the degree of transparency of the element."}),overflow:s.i18n.translate("xpack.canvas.functions.containerStyle.args.overflowHelpText",{defaultMessage:"A valid {CSS} overflow.",values:{CSS:n.e}}),padding:s.i18n.translate("xpack.canvas.functions.containerStyle.args.paddingHelpText",{defaultMessage:"The distance of the content, in pixels, from the border."})}},S={invalidBackgroundImage:()=>new Error(s.i18n.translate("xpack.canvas.functions.containerStyle.invalidBackgroundImageErrorMessage",{defaultMessage:"Invalid backgroundImage. Please provide an asset or a URL."}))},H={help:s.i18n.translate("xpack.canvas.functions.contextHelpText",{defaultMessage:"Returns whatever you pass into it. This can be useful when you need to use {CONTEXT} as argument to a function as a sub-expression.",values:{CONTEXT:n.d}}),args:{}},N={help:s.i18n.translate("xpack.canvas.functions.csvHelpText",{defaultMessage:"Creates a {DATATABLE} from {CSV} input.",values:{DATATABLE:n.g,CSV:n.f}}),args:{data:s.i18n.translate("xpack.canvas.functions.csv.args.dataHelpText",{defaultMessage:"The {CSV} data to use.",values:{CSV:n.f}}),delimiter:s.i18n.translate("xpack.canvas.functions.csv.args.delimeterHelpText",{defaultMessage:"The data separation character."}),newline:s.i18n.translate("xpack.canvas.functions.csv.args.newlineHelpText",{defaultMessage:"The row separation character."})}},E={invalidInputCSV:()=>new Error(s.i18n.translate("xpack.canvas.functions.csv.invalidInputCSVErrorMessage",{defaultMessage:"Error parsing input CSV."}))},L={help:s.i18n.translate("xpack.canvas.functions.dateHelpText",{defaultMessage:"Returns the current time, or a time parsed from a specified string, as milliseconds since epoch."}),args:{value:s.i18n.translate("xpack.canvas.functions.date.args.valueHelpText",{defaultMessage:"An optional date string that is parsed into milliseconds since epoch. The date string can be either a valid {JS} {date} input or a string to parse using the {formatArg} argument. Must be an {ISO8601} string, or you must provide the format.",values:{JS:n.q,date:"`Date`",formatArg:"`format`",ISO8601:n.p}}),format:s.i18n.translate("xpack.canvas.functions.date.args.formatHelpText",{defaultMessage:"The {MOMENTJS} format used to parse the specified date string. For more information, see {url}.",values:{MOMENTJS:n.v,url:"https://momentjs.com/docs/#/displaying/"}})}},D={invalidDateInput:e=>new Error(s.i18n.translate("xpack.canvas.functions.date.invalidDateInputErrorMessage",{defaultMessage:"Invalid date input: {date}",values:{date:e}}))};let C;!function(e){e.CI="ci",e.SHIRTS="shirts"}(C||(C={}));const A={help:s.i18n.translate("xpack.canvas.functions.demodataHelpText",{defaultMessage:"A sample data set that includes project {ci} times with usernames, countries, and run phases.",values:{ci:"CI"}}),args:{type:s.i18n.translate("xpack.canvas.functions.demodata.args.typeHelpText",{defaultMessage:"The name of the demo data set to use."})}},F={invalidDataSet:e=>new Error(s.i18n.translate("xpack.canvas.functions.demodata.invalidDataSetErrorMessage",{defaultMessage:"Invalid data set: '{arg}', use '{ci}' or '{shirts}'.",values:{arg:e,ci:C.CI,shirts:C.SHIRTS}}))},O={help:s.i18n.translate("xpack.canvas.functions.doHelpText",{defaultMessage:"Executes multiple sub-expressions, then returns the original {CONTEXT}. Use for running functions that produce an action or a side effect without changing the original {CONTEXT}.",values:{CONTEXT:n.d}}),args:{fn:s.i18n.translate("xpack.canvas.functions.do.args.fnHelpText",{defaultMessage:"The sub-expressions to execute. The return values of these sub-expressions are not available in the root pipeline as this function simply returns the original {CONTEXT}.",values:{CONTEXT:n.d}})}},I={help:s.i18n.translate("xpack.canvas.functions.dropdownControlHelpText",{defaultMessage:"Configures a dropdown filter control element."}),args:{filterColumn:s.i18n.translate("xpack.canvas.functions.dropdownControl.args.filterColumnHelpText",{defaultMessage:"The column or field that you want to filter."}),labelColumn:s.i18n.translate("xpack.canvas.functions.dropdownControl.args.labelColumnHelpText",{defaultMessage:"The column or field to use as the label in the dropdown control"}),valueColumn:s.i18n.translate("xpack.canvas.functions.dropdownControl.args.valueColumnHelpText",{defaultMessage:"The column or field from which to extract the unique values for the dropdown control."}),filterGroup:s.i18n.translate("xpack.canvas.functions.dropdownControl.args.filterGroupHelpText",{defaultMessage:"The group name for the filter."})}},R={help:s.i18n.translate("xpack.canvas.functions.eqHelpText",{defaultMessage:"Returns whether the {CONTEXT} is equal to the argument.",values:{CONTEXT:n.d}}),args:{value:s.i18n.translate("xpack.canvas.functions.eq.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},B={help:s.i18n.translate("xpack.canvas.functions.embeddableHelpText",{defaultMessage:"Returns an embeddable with the provided configuration"}),args:{config:s.i18n.translate("xpack.canvas.functions.embeddable.args.idHelpText",{defaultMessage:"The base64 encoded embeddable input object"}),type:s.i18n.translate("xpack.canvas.functions.embeddable.args.typeHelpText",{defaultMessage:"The embeddable type"})}},_={help:s.i18n.translate("xpack.canvas.functions.escountHelpText",{defaultMessage:"Query {ELASTICSEARCH} for the number of hits matching the specified query.",values:{ELASTICSEARCH:n.i}}),args:{query:s.i18n.translate("xpack.canvas.functions.escount.args.queryHelpText",{defaultMessage:"A {LUCENE} query string.",values:{LUCENE:n.s}}),index:s.i18n.translate("xpack.canvas.functions.escount.args.indexHelpText",{defaultMessage:"An index or data view. For example, {example}.",values:{example:'`"logstash-*"`'}})}},P={help:s.i18n.translate("xpack.canvas.functions.esdocsHelpText",{defaultMessage:"Query {ELASTICSEARCH} for raw documents. Specify the fields you want to retrieve, especially if you are asking for a lot of rows.",values:{ELASTICSEARCH:n.i}}),args:{query:s.i18n.translate("xpack.canvas.functions.esdocs.args.queryHelpText",{defaultMessage:"A {LUCENE} query string.",values:{LUCENE:n.s}}),count:s.i18n.translate("xpack.canvas.functions.esdocs.args.countHelpText",{defaultMessage:"The number of documents to retrieve. For better performance, use a smaller data set."}),fields:s.i18n.translate("xpack.canvas.functions.esdocs.args.fieldsHelpText",{defaultMessage:"A comma-separated list of fields. For better performance, use fewer fields."}),index:s.i18n.translate("xpack.canvas.functions.esdocs.args.indexHelpText",{defaultMessage:"An index or data view. For example, {example}.",values:{example:'`"logstash-*"`'}}),metaFields:s.i18n.translate("xpack.canvas.functions.esdocs.args.metaFieldsHelpText",{defaultMessage:"Comma separated list of meta fields. For example, {example}.",values:{example:'`"_index,_type"`'}}),sort:s.i18n.translate("xpack.canvas.functions.esdocs.args.sortHelpText",{defaultMessage:"The sort direction formatted as {directions}. For example, {example1} or {example2}.",values:{directions:`\`"${["field","direction"].join(", ")}"\``,example1:`\`"${["@timestamp","desc"].join(", ")}"\``,example2:`\`"${["bytes","asc"].join(", ")}"\``}})}},U={help:s.i18n.translate("xpack.canvas.functions.exactlyHelpText",{defaultMessage:"Creates a filter that matches a given column to an exact value."}),args:{column:s.i18n.translate("xpack.canvas.functions.exactly.args.columnHelpText",{defaultMessage:"The column or field that you want to filter."}),value:s.i18n.translate("xpack.canvas.functions.exactly.args.valueHelpText",{defaultMessage:"The value to match exactly, including white space and capitalization."}),filterGroup:s.i18n.translate("xpack.canvas.functions.exactly.args.filterGroupHelpText",{defaultMessage:"The group name for the filter."})}},G={help:s.i18n.translate("xpack.canvas.functions.filterrowsHelpText",{defaultMessage:"Filters rows in a {DATATABLE} based on the return value of a sub-expression.",values:{DATATABLE:n.g}}),args:{fn:s.i18n.translate("xpack.canvas.functions.filterrows.args.fnHelpText",{defaultMessage:"An expression to pass into each row in the {DATATABLE}. The expression should return a {TYPE_BOOLEAN}. A {BOOLEAN_TRUE} value preserves the row, and a {BOOLEAN_FALSE} value removes it.",values:{BOOLEAN_FALSE:n.a,BOOLEAN_TRUE:n.b,DATATABLE:n.g,TYPE_BOOLEAN:n.G}})}},V={help:s.i18n.translate("xpack.canvas.functions.filtersHelpText",{defaultMessage:"Aggregates element filters from the workpad for use elsewhere, usually a data source."}),args:{group:s.i18n.translate("xpack.canvas.functions.filters.args.group",{defaultMessage:"The name of the filter group to use."}),ungrouped:s.i18n.translate("xpack.canvas.functions.filters.args.ungrouped",{defaultMessage:"Exclude filters that belong to a filter group?"})}},z={help:s.i18n.translate("xpack.canvas.functions.formatdateHelpText",{defaultMessage:"Formats an {ISO8601} date string or a date in milliseconds since epoch using {MOMENTJS}. See {url}.",values:{ISO8601:n.p,MOMENTJS:n.v,url:"https://momentjs.com/docs/#/displaying/"}}),args:{format:s.i18n.translate("xpack.canvas.functions.formatdate.args.formatHelpText",{defaultMessage:"A {MOMENTJS} format. For example, {example}. See {url}.",values:{MOMENTJS:n.v,example:'`"MM/DD/YYYY"`',url:"https://momentjs.com/docs/#/displaying/"}})}},q={help:s.i18n.translate("xpack.canvas.functions.formatnumberHelpText",{defaultMessage:"Formats a number into a formatted number string using the {NUMERALJS}.",values:{NUMERALJS:n.x}}),args:{format:s.i18n.translate("xpack.canvas.functions.formatnumber.args.formatHelpText",{defaultMessage:"A {NUMERALJS} format string. For example, {example1} or {example2}.",values:{example1:'`"0.0a"`',example2:'`"0%"`',NUMERALJS:n.x}})}},X={help:s.i18n.translate("xpack.canvas.functions.getCellHelpText",{defaultMessage:"Fetches a single cell from a {DATATABLE}.",values:{DATATABLE:n.g}}),args:{column:s.i18n.translate("xpack.canvas.functions.getCell.args.columnHelpText",{defaultMessage:"The name of the column to fetch the value from. If not provided, the value is retrieved from the first column."}),row:s.i18n.translate("xpack.canvas.functions.getCell.args.rowHelpText",{defaultMessage:"The row number, starting at 0."})}},W={rowNotFound:e=>new Error(s.i18n.translate("xpack.canvas.functions.getCell.rowNotFoundErrorMessage",{defaultMessage:"Row not found: '{row}'",values:{row:e}})),columnNotFound:e=>new Error(s.i18n.translate("xpack.canvas.functions.getCell.columnNotFoundErrorMessage",{defaultMessage:"Column not found: '{column}'",values:{column:e}}))},Y={help:s.i18n.translate("xpack.canvas.functions.gtHelpText",{defaultMessage:"Returns whether the {CONTEXT} is greater than the argument.",values:{CONTEXT:n.d}}),args:{value:s.i18n.translate("xpack.canvas.functions.gt.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},j={help:s.i18n.translate("xpack.canvas.functions.gteHelpText",{defaultMessage:"Returns whether the {CONTEXT} is greater or equal to the argument.",values:{CONTEXT:n.d}}),args:{value:s.i18n.translate("xpack.canvas.functions.gte.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},J={help:s.i18n.translate("xpack.canvas.functions.headHelpText",{defaultMessage:"Retrieves the first {n} rows from the {DATATABLE}. See also {tailFn}.",values:{n:"N",DATATABLE:n.g,tailFn:"`tail`"}}),args:{count:s.i18n.translate("xpack.canvas.functions.head.args.countHelpText",{defaultMessage:"The number of rows to retrieve from the beginning of the {DATATABLE}.",values:{DATATABLE:n.g}})}},Q={help:s.i18n.translate("xpack.canvas.functions.ifHelpText",{defaultMessage:"Performs conditional logic."}),args:{condition:s.i18n.translate("xpack.canvas.functions.if.args.conditionHelpText",{defaultMessage:"A {BOOLEAN_TRUE} or {BOOLEAN_FALSE} indicating whether a condition is met, usually returned by a sub-expression. When unspecified, the original {CONTEXT} is returned.",values:{BOOLEAN_TRUE:n.b,BOOLEAN_FALSE:n.a,CONTEXT:n.d}}),then:s.i18n.translate("xpack.canvas.functions.if.args.thenHelpText",{defaultMessage:"The return value when the condition is {BOOLEAN_TRUE}. When unspecified and the condition is met, the original {CONTEXT} is returned.",values:{BOOLEAN_TRUE:n.b,CONTEXT:n.d}}),else:s.i18n.translate("xpack.canvas.functions.if.args.elseHelpText",{defaultMessage:"The return value when the condition is {BOOLEAN_FALSE}. When unspecified and the condition is not met, the original {CONTEXT} is returned.",values:{BOOLEAN_FALSE:n.a,CONTEXT:n.d}})}},$={help:s.i18n.translate("xpack.canvas.functions.joinRowsHelpText",{defaultMessage:"Concatenates values from rows in a `datatable` into a single string."}),args:{column:s.i18n.translate("xpack.canvas.functions.joinRows.args.columnHelpText",{defaultMessage:"The column or field from which to extract the values."}),separator:s.i18n.translate("xpack.canvas.functions.joinRows.args.separatorHelpText",{defaultMessage:"The delimiter to insert between each extracted value."}),quote:s.i18n.translate("xpack.canvas.functions.joinRows.args.quoteHelpText",{defaultMessage:"The quote character to wrap around each extracted value."}),distinct:s.i18n.translate("xpack.canvas.functions.joinRows.args.distinctHelpText",{defaultMessage:"Extract only unique values?"})}},K={columnNotFound:e=>new Error(s.i18n.translate("xpack.canvas.functions.joinRows.columnNotFoundErrorMessage",{defaultMessage:"Column not found: '{column}'",values:{column:e}}))},Z={help:s.i18n.translate("xpack.canvas.functions.locationHelpText",{defaultMessage:"Find your current location using the {geolocationAPI} of the browser. Performance can vary, but is fairly accurate. See {url}. Don’t use {locationFn} if you plan to generate PDFs as this function requires user input.",values:{geolocationAPI:"Geolocation API",url:"https://developer.mozilla.org/en-US/docs/Web/API/Navigator/geolocation",locationFn:"`location`"}}),args:{}},ee={help:s.i18n.translate("xpack.canvas.functions.ltHelpText",{defaultMessage:"Returns whether the {CONTEXT} is less than the argument.",values:{CONTEXT:n.d}}),args:{value:s.i18n.translate("xpack.canvas.functions.lt.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},ae={help:s.i18n.translate("xpack.canvas.functions.lteHelpText",{defaultMessage:"Returns whether the {CONTEXT} is less than or equal to the argument.",values:{CONTEXT:n.d}}),args:{value:s.i18n.translate("xpack.canvas.functions.lte.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},te={help:s.i18n.translate("xpack.canvas.functions.mapCenterHelpText",{defaultMessage:"Returns an object with the center coordinates and zoom level of the map."}),args:{lat:s.i18n.translate("xpack.canvas.functions.mapCenter.args.latHelpText",{defaultMessage:"Latitude for the center of the map"}),lon:s.i18n.translate("xpack.canvas.functions.savedMap.args.lonHelpText",{defaultMessage:"Longitude for the center of the map"}),zoom:s.i18n.translate("xpack.canvas.functions.savedMap.args.zoomHelpText",{defaultMessage:"Zoom level of the map"})}},se={help:s.i18n.translate("xpack.canvas.functions.markdownHelpText",{defaultMessage:"Adds an element that renders {MARKDOWN} text. TIP: Use the {markdownFn} function for single numbers, metrics, and paragraphs of text.",values:{MARKDOWN:n.u,markdownFn:"`markdown`"}}),args:{content:s.i18n.translate("xpack.canvas.functions.markdown.args.contentHelpText",{defaultMessage:"A string of text that contains {MARKDOWN}. To concatenate, pass the {stringFn} function multiple times.",values:{MARKDOWN:n.u,stringFn:"`string`"}}),font:s.i18n.translate("xpack.canvas.functions.markdown.args.fontHelpText",{defaultMessage:"The {CSS} font properties for the content. For example, {fontFamily} or {fontWeight}.",values:{CSS:n.e,fontFamily:'"font-family"',fontWeight:'"font-weight"'}}),openLinksInNewTab:s.i18n.translate("xpack.canvas.functions.markdown.args.openLinkHelpText",{defaultMessage:"A true or false value for opening links in a new tab. The default value is `false`. Setting to `true` opens all links in a new tab."})}},ne={help:s.i18n.translate("xpack.canvas.functions.neqHelpText",{defaultMessage:"Returns whether the {CONTEXT} is not equal to the argument.",values:{CONTEXT:n.d}}),args:{value:s.i18n.translate("xpack.canvas.functions.neq.args.valueHelpText",{defaultMessage:"The value compared to the {CONTEXT}.",values:{CONTEXT:n.d}})}},le={help:s.i18n.translate("xpack.canvas.functions.pieHelpText",{defaultMessage:"Configures a pie chart element."}),args:{font:s.i18n.translate("xpack.canvas.functions.pie.args.fontHelpText",{defaultMessage:"The {CSS} font properties for the labels. For example, {FONT_FAMILY} or {FONT_WEIGHT}.",values:{CSS:n.e,FONT_FAMILY:n.k,FONT_WEIGHT:n.l}}),hole:s.i18n.translate("xpack.canvas.functions.pie.args.holeHelpText",{defaultMessage:"Draws a hole in the pie, between `0` and `100`, as a percentage of the pie radius."}),labelRadius:s.i18n.translate("xpack.canvas.functions.pie.args.labelRadiusHelpText",{defaultMessage:"The percentage of the container area to use as a radius for the label circle."}),labels:s.i18n.translate("xpack.canvas.functions.pie.args.labelsHelpText",{defaultMessage:"Display the pie labels?"}),legend:s.i18n.translate("xpack.canvas.functions.pie.args.legendHelpText",{defaultMessage:"The legend position. For example, {legend}, or {BOOLEAN_FALSE}. When {BOOLEAN_FALSE}, the legend is hidden.",values:{legend:Object.values(d.Legend).map((e=>`\`"${e}"\``)).join(", "),BOOLEAN_FALSE:n.a}}),palette:s.i18n.translate("xpack.canvas.functions.pie.args.paletteHelpText",{defaultMessage:"A {palette} object for describing the colors to use in this pie chart.",values:{palette:"`palette`"}}),radius:s.i18n.translate("xpack.canvas.functions.pie.args.radiusHelpText",{defaultMessage:"The radius of the pie as a percentage, between `0` and `1`, of the available space. To automatically set the radius, use {auto}.",values:{auto:'`"auto"`'}}),seriesStyle:s.i18n.translate("xpack.canvas.functions.pie.args.seriesStyleHelpText",{defaultMessage:"A style of a specific series"}),tilt:s.i18n.translate("xpack.canvas.functions.pie.args.tiltHelpText",{defaultMessage:"The percentage of tilt where `1` is fully vertical, and `0` is completely flat."})}},ie={help:s.i18n.translate("xpack.canvas.functions.plotHelpText",{defaultMessage:"Configures a chart element."}),args:{defaultStyle:s.i18n.translate("xpack.canvas.functions.plot.args.defaultStyleHelpText",{defaultMessage:"The default style to use for every series."}),font:s.i18n.translate("xpack.canvas.functions.plot.args.fontHelpText",{defaultMessage:"The {CSS} font properties for the labels. For example, {FONT_FAMILY} or {FONT_WEIGHT}.",values:{CSS:n.e,FONT_FAMILY:n.k,FONT_WEIGHT:n.l}}),legend:s.i18n.translate("xpack.canvas.functions.plot.args.legendHelpText",{defaultMessage:"The legend position. For example, {legend}, or {BOOLEAN_FALSE}. When {BOOLEAN_FALSE}, the legend is hidden.",values:{legend:Object.values(d.Legend).map((e=>`\`"${e}"\``)).join(", "),BOOLEAN_FALSE:n.a}}),palette:s.i18n.translate("xpack.canvas.functions.plot.args.paletteHelpText",{defaultMessage:"A {palette} object for describing the colors to use in this chart.",values:{palette:"`palette`"}}),seriesStyle:s.i18n.translate("xpack.canvas.functions.plot.args.seriesStyleHelpText",{defaultMessage:"A style of a specific series"}),xaxis:s.i18n.translate("xpack.canvas.functions.plot.args.xaxisHelpText",{defaultMessage:"The axis configuration. When {BOOLEAN_FALSE}, the axis is hidden.",values:{BOOLEAN_FALSE:n.a}}),yaxis:s.i18n.translate("xpack.canvas.functions.plot.args.yaxisHelpText",{defaultMessage:"The axis configuration. When {BOOLEAN_FALSE}, the axis is hidden.",values:{BOOLEAN_FALSE:n.a}})}},re={help:s.i18n.translate("xpack.canvas.functions.plyHelpText",{defaultMessage:"Subdivides a {DATATABLE} by the unique values of the specified columns, and passes the resulting tables into an expression, then merges the outputs of each expression.",values:{DATATABLE:n.g}}),args:{by:s.i18n.translate("xpack.canvas.functions.ply.args.byHelpText",{defaultMessage:"The column to subdivide the {DATATABLE}.",values:{DATATABLE:n.g}}),expression:s.i18n.translate("xpack.canvas.functions.ply.args.expressionHelpText",{defaultMessage:"An expression to pass each resulting {DATATABLE} into. Tips: Expressions must return a {DATATABLE}. Use {asFn} to turn literals into {DATATABLE}s. Multiple expressions must return the same number of rows.If you need to return a different row count, pipe into another instance of {plyFn}. If multiple expressions returns the columns with the same name, the last one wins.",values:{asFn:"`as`",DATATABLE:n.g,plyFn:"`ply`"}})}},oe={columnNotFound:e=>new Error(s.i18n.translate("xpack.canvas.functions.ply.columnNotFoundErrorMessage",{defaultMessage:"Column not found: '{by}'",values:{by:e}})),rowCountMismatch:()=>new Error(s.i18n.translate("xpack.canvas.functions.ply.rowCountMismatchErrorMessage",{defaultMessage:"All expressions must return the same number of rows"}))},ce={help:s.i18n.translate("xpack.canvas.functions.pointseriesHelpText",{defaultMessage:"Turn a {DATATABLE} into a point series model. Currently we differentiate measure from dimensions by looking for a {TINYMATH} expression. See {TINYMATH_URL}. If you enter a {TINYMATH} expression in your argument, we treat that argument as a measure, otherwise it is a dimension. Dimensions are combined to create unique keys. Measures are then deduplicated by those keys using the specified {TINYMATH} function",values:{DATATABLE:n.g,TINYMATH:n.E,TINYMATH_URL:n.F}}),args:{color:s.i18n.translate("xpack.canvas.functions.pointseries.args.colorHelpText",{defaultMessage:"An expression to use in determining the mark's color."}),size:s.i18n.translate("xpack.canvas.functions.pointseries.args.sizeHelpText",{defaultMessage:"The size of the marks. Only applicable to supported elements."}),text:s.i18n.translate("xpack.canvas.functions.pointseries.args.textHelpText",{defaultMessage:"The text to show on the mark. Only applicable to supported elements."}),x:s.i18n.translate("xpack.canvas.functions.pointseries.args.xHelpText",{defaultMessage:"The values along the X-axis."}),y:s.i18n.translate("xpack.canvas.functions.pointseries.args.yHelpText",{defaultMessage:"The values along the Y-axis."})}},ue={unwrappedExpression:()=>new Error(s.i18n.translate("xpack.canvas.functions.pointseries.unwrappedExpressionErrorMessage",{defaultMessage:"Expressions must be wrapped in a function such as {fn}",values:{fn:"sum()"}}))},pe={help:s.i18n.translate("xpack.canvas.functions.renderHelpText",{defaultMessage:"Renders the {CONTEXT} as a specific element and sets element level options, such as background and border styling.",values:{CONTEXT:n.d}}),args:{as:s.i18n.translate("xpack.canvas.functions.render.args.asHelpText",{defaultMessage:"The element type to render. You probably want a specialized function instead, such as {plotFn} or {shapeFn}.",values:{plotFn:"`plot`",shapeFn:"`shape`"}}),css:s.i18n.translate("xpack.canvas.functions.render.args.cssHelpText",{defaultMessage:"Any block of custom {CSS} to be scoped to the element.",values:{CSS:n.e}}),containerStyle:s.i18n.translate("xpack.canvas.functions.render.args.containerStyleHelpText",{defaultMessage:"The style for the container, including background, border, and opacity."})}},ge={help:s.i18n.translate("xpack.canvas.functions.replaceImageHelpText",{defaultMessage:"Uses a regular expression to replace parts of a string."}),args:{pattern:s.i18n.translate("xpack.canvas.functions.replace.args.patternHelpText",{defaultMessage:"The text or pattern of a {JS} regular expression. For example, {example}. You can use capturing groups here.",values:{JS:n.q,example:'`"[aeiou]"`'}}),flags:s.i18n.translate("xpack.canvas.functions.replace.args.flagsHelpText",{defaultMessage:"Specify flags. See {url}.",values:{url:"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp"}}),replacement:s.i18n.translate("xpack.canvas.functions.replace.args.replacementHelpText",{defaultMessage:"The replacement for the matching parts of string. Capturing groups can be accessed by their index. For example, {example}.",values:{example:'`"$1"`'}})}},de={help:s.i18n.translate("xpack.canvas.functions.rounddateHelpText",{defaultMessage:"Uses a {MOMENTJS} formatting string to round milliseconds since epoch, and returns milliseconds since epoch.",values:{MOMENTJS:n.v}}),args:{format:s.i18n.translate("xpack.canvas.functions.rounddate.args.formatHelpText",{defaultMessage:"The {MOMENTJS} format to use for bucketing. For example, {example} rounds to months. See {url}.",values:{example:'`"YYYY-MM"`',MOMENTJS:n.v,url:"https://momentjs.com/docs/#/displaying/"}})}},fe={help:s.i18n.translate("xpack.canvas.functions.rowCountHelpText",{defaultMessage:"Returns the number of rows. Pairs with {plyFn} to get the count of unique column values, or combinations of unique column values.",values:{plyFn:"`ply`"}}),args:{}},me={help:s.i18n.translate("xpack.canvas.functions.savedLensHelpText",{defaultMessage:"Returns an embeddable for a saved Lens visualization object."}),args:{id:s.i18n.translate("xpack.canvas.functions.savedLens.args.idHelpText",{defaultMessage:"The ID of the saved Lens visualization object"}),timerange:s.i18n.translate("xpack.canvas.functions.savedLens.args.timerangeHelpText",{defaultMessage:"The timerange of data that should be included"}),title:s.i18n.translate("xpack.canvas.functions.savedLens.args.titleHelpText",{defaultMessage:"The title for the Lens visualization object"}),palette:s.i18n.translate("xpack.canvas.functions.savedLens.args.paletteHelpText",{defaultMessage:"The palette used for the Lens visualization"})}},ve={help:s.i18n.translate("xpack.canvas.functions.savedMapHelpText",{defaultMessage:"Returns an embeddable for a saved map object."}),args:{id:s.i18n.translate("xpack.canvas.functions.savedMap.args.idHelpText",{defaultMessage:"The ID of the saved map object"}),center:s.i18n.translate("xpack.canvas.functions.savedMap.args.centerHelpText",{defaultMessage:"The center and zoom level the map should have"}),hideLayer:s.i18n.translate("xpack.canvas.functions.savedMap.args.hideLayer",{defaultMessage:"The IDs of map layers that should be hidden"}),timerange:s.i18n.translate("xpack.canvas.functions.savedMap.args.timerangeHelpText",{defaultMessage:"The timerange of data that should be included"}),title:s.i18n.translate("xpack.canvas.functions.savedMap.args.titleHelpText",{defaultMessage:"The title for the map"})}},xe={help:s.i18n.translate("xpack.canvas.functions.savedSearchHelpText",{defaultMessage:"Returns an embeddable for a saved search object"}),args:{id:"The id of the saved search object"}},he={help:s.i18n.translate("xpack.canvas.functions.savedVisualizationHelpText",{defaultMessage:"Returns an embeddable for a saved visualization object."}),args:{id:s.i18n.translate("xpack.canvas.functions.savedVisualization.args.idHelpText",{defaultMessage:"The ID of the saved visualization object"}),timerange:s.i18n.translate("xpack.canvas.functions.savedVisualization.args.timerangeHelpText",{defaultMessage:"The timerange of data that should be included"}),colors:s.i18n.translate("xpack.canvas.functions.savedVisualization.args.colorsHelpText",{defaultMessage:"Defines the color to use for a specific series"}),hideLegend:s.i18n.translate("xpack.canvas.functions.savedVisualization.args.hideLegendHelpText",{defaultMessage:"Specifies the option to hide the legend"}),title:s.i18n.translate("xpack.canvas.functions.savedVisualization.args.titleHelpText",{defaultMessage:"The title for the visualization object"})}},Te={help:s.i18n.translate("xpack.canvas.functions.seriesStyleHelpText",{defaultMessage:"Creates an object used for describing the properties of a series on a chart. Use {seriesStyleFn} inside of a charting function, like {plotFn} or {pieFn}.",values:{seriesStyleFn:"`seriesStyle`",pieFn:"`pie`",plotFn:"`plot`"}}),args:{bars:s.i18n.translate("xpack.canvas.functions.seriesStyle.args.barsHelpText",{defaultMessage:"The width of bars."}),color:s.i18n.translate("xpack.canvas.functions.seriesStyle.args.colorHelpText",{defaultMessage:"The line color."}),fill:s.i18n.translate("xpack.canvas.functions.seriesStyle.args.fillHelpText",{defaultMessage:"Should we fill in the points?"}),horizontalBars:s.i18n.translate("xpack.canvas.functions.seriesStyle.args.horizontalBarsHelpText",{defaultMessage:"Sets the orientation of the bars in the chart to horizontal."}),label:s.i18n.translate("xpack.canvas.functions.seriesStyle.args.labelHelpText",{defaultMessage:"The name of the series to style."}),lines:s.i18n.translate("xpack.canvas.functions.seriesStyle.args.linesHelpText",{defaultMessage:"The width of the line."}),points:s.i18n.translate("xpack.canvas.functions.seriesStyle.args.pointsHelpText",{defaultMessage:"The size of points on line."}),stack:s.i18n.translate("xpack.canvas.functions.seriesStyle.args.stackHelpText",{defaultMessage:"Specifies if the series should be stacked. The number is the stack ID. Series with the same stack ID are stacked together."})}},Me={help:s.i18n.translate("xpack.canvas.functions.sortHelpText",{defaultMessage:"Sorts a {DATATABLE} by the specified column.",values:{DATATABLE:n.g}}),args:{by:s.i18n.translate("xpack.canvas.functions.sort.args.byHelpText",{defaultMessage:"The column to sort by. When unspecified, the {DATATABLE} is sorted by the first column.",values:{DATATABLE:n.g}}),reverse:s.i18n.translate("xpack.canvas.functions.sort.args.reverseHelpText",{defaultMessage:"Reverses the sorting order. When unspecified, the {DATATABLE} is sorted in ascending order.",values:{DATATABLE:n.g}})}},ke={help:s.i18n.translate("xpack.canvas.functions.staticColumnHelpText",{defaultMessage:"Adds a column with the same static value in every row. See also {alterColumnFn}, {mapColumnFn}, and {mathColumnFn}",values:{alterColumnFn:"`alterColumn`",mapColumnFn:"`mapColumn`",mathColumnFn:"`mathColumn`"}}),args:{name:s.i18n.translate("xpack.canvas.functions.staticColumn.args.nameHelpText",{defaultMessage:"The name of the new column."}),value:s.i18n.translate("xpack.canvas.functions.staticColumn.args.valueHelpText",{defaultMessage:"The value to insert in each row in the new column. TIP: use a sub-expression to rollup other columns into a static value."})}},ye={help:s.i18n.translate("xpack.canvas.functions.stringHelpText",{defaultMessage:"Concatenates all of the arguments into a single string."}),args:{value:s.i18n.translate("xpack.canvas.functions.string.args.valueHelpText",{defaultMessage:"The values to join together into one string. Include spaces where needed."})}},be={help:s.i18n.translate("xpack.canvas.functions.switchHelpText",{defaultMessage:"Performs conditional logic with multiple conditions. See also {caseFn}, which builds a {case} to pass to the {switchFn} function.",values:{case:"`case`",caseFn:"`case`",switchFn:"`switch`"}}),args:{case:s.i18n.translate("xpack.canvas.functions.switch.args.caseHelpText",{defaultMessage:"The conditions to check."}),default:s.i18n.translate("xpack.canvas.functions.switch.args.defaultHelpText",{defaultMessage:"The value returned when no conditions are met. When unspecified and no conditions are met, the original {CONTEXT} is returned.",values:{CONTEXT:n.d}})}},we={help:s.i18n.translate("xpack.canvas.functions.tableHelpText",{defaultMessage:"Configures a table element."}),args:{font:s.i18n.translate("xpack.canvas.functions.table.args.fontHelpText",{defaultMessage:"The {CSS} font properties for the contents of the table. For example, {FONT_FAMILY} or {FONT_WEIGHT}.",values:{CSS:n.e,FONT_FAMILY:n.k,FONT_WEIGHT:n.l}}),paginate:s.i18n.translate("xpack.canvas.functions.table.args.paginateHelpText",{defaultMessage:"Show pagination controls? When {BOOLEAN_FALSE}, only the first page is displayed.",values:{BOOLEAN_FALSE:n.a}}),perPage:s.i18n.translate("xpack.canvas.functions.table.args.perPageHelpText",{defaultMessage:"The number of rows to display on each page."}),showHeader:s.i18n.translate("xpack.canvas.functions.table.args.showHeaderHelpText",{defaultMessage:"Show or hide the header row with titles for each column."})}},Se={help:s.i18n.translate("xpack.canvas.functions.tailHelpText",{defaultMessage:"Retrieves the last N rows from the end of a {DATATABLE}. See also {headFn}.",values:{DATATABLE:n.g,headFn:"`head`"}}),args:{count:s.i18n.translate("xpack.canvas.functions.tail.args.countHelpText",{defaultMessage:"The number of rows to retrieve from the end of the {DATATABLE}.",values:{DATATABLE:n.g}})}},He={help:s.i18n.translate("xpack.canvas.functions.timefilterHelpText",{defaultMessage:"Creates a time filter for querying a source."}),args:{column:s.i18n.translate("xpack.canvas.functions.timefilter.args.columnHelpText",{defaultMessage:"The column or field that you want to filter."}),from:s.i18n.translate("xpack.canvas.functions.timefilter.args.fromHelpText",{defaultMessage:"The beginning of the range, in {ISO8601} or {ELASTICSEARCH} {DATEMATH} format",values:{DATEMATH:n.h,ELASTICSEARCH:n.i,ISO8601:n.p}}),to:s.i18n.translate("xpack.canvas.functions.timefilter.args.toHelpText",{defaultMessage:"The end of the range, in {ISO8601} or {ELASTICSEARCH} {DATEMATH} format",values:{DATEMATH:n.h,ELASTICSEARCH:n.i,ISO8601:n.p}}),filterGroup:s.i18n.translate("xpack.canvas.functions.timefilter.args.filterGroupHelpText",{defaultMessage:"The group name for the filter."})}},Ne={invalidString:e=>new Error(s.i18n.translate("xpack.canvas.functions.timefilter.invalidStringErrorMessage",{defaultMessage:"Invalid date/time string: '{str}'",values:{str:e}}))},Ee={help:s.i18n.translate("xpack.canvas.functions.timefilterControlHelpText",{defaultMessage:"Configures a time filter control element."}),args:{column:s.i18n.translate("xpack.canvas.functions.timefilterControl.args.columnHelpText",{defaultMessage:"The column or field that you want to filter."}),compact:s.i18n.translate("xpack.canvas.functions.timefilterControl.args.compactHelpText",{defaultMessage:"Shows the time filter as a button, which triggers a popover."}),filterGroup:s.i18n.translate("xpack.canvas.functions.dropdownControl.args.filterGroupHelpText",{defaultMessage:"The group name for the filter."})}},Le={help:s.i18n.translate("xpack.canvas.functions.timelionHelpText",{defaultMessage:"Uses Timelion to extract one or more time series from many sources."}),args:{query:s.i18n.translate("xpack.canvas.functions.timelion.args.query",{defaultMessage:"A Timelion query"}),interval:s.i18n.translate("xpack.canvas.functions.timelion.args.interval",{defaultMessage:"The bucket interval for the time series."}),from:s.i18n.translate("xpack.canvas.functions.timelion.args.from",{defaultMessage:"The {ELASTICSEARCH} {DATEMATH} string for the beginning of the time range.",values:{ELASTICSEARCH:n.i,DATEMATH:n.h}}),to:s.i18n.translate("xpack.canvas.functions.timelion.args.to",{defaultMessage:"The {ELASTICSEARCH} {DATEMATH} string for the end of the time range.",values:{ELASTICSEARCH:n.i,DATEMATH:n.h}}),timezone:s.i18n.translate("xpack.canvas.functions.timelion.args.timezone",{defaultMessage:"The timezone for the time range. See {MOMENTJS_TIMEZONE_URL}.",values:{MOMENTJS_TIMEZONE_URL:n.w}})}},De={help:s.i18n.translate("xpack.canvas.functions.timerangeHelpText",{defaultMessage:"An object that represents a span of time."}),args:{from:s.i18n.translate("xpack.canvas.functions.timerange.args.fromHelpText",{defaultMessage:"The start of the time range"}),to:s.i18n.translate("xpack.canvas.functions.timerange.args.toHelpText",{defaultMessage:"The end of the time range"})}},Ce={help:s.i18n.translate("xpack.canvas.functions.toHelpText",{defaultMessage:"Explicitly casts the type of the {CONTEXT} from one type to the specified type.",values:{CONTEXT:n.d}}),args:{type:s.i18n.translate("xpack.canvas.functions.to.args.type",{defaultMessage:"A known data type in the expression language."})}},Ae={missingType:()=>new Error(s.i18n.translate("xpack.canvas.functions.to.missingType",{defaultMessage:"Must specify a casting type"}))},Fe={help:s.i18n.translate("xpack.canvas.functions.urlparamHelpText",{defaultMessage:"Retrieves a {URL} parameter to use in an expression. The {urlparamFn} function always returns a {TYPE_STRING}. For example, you can retrieve the value {value} from the parameter {myVar} from the {URL} {example}.",values:{example:"`https://localhost:5601/app/canvas?myVar=20`",myVar:"`myVar`",TYPE_STRING:n.J,URL:n.K,urlparamFn:"`urlparam`",value:'`"20"`'}}),args:{param:s.i18n.translate("xpack.canvas.functions.urlparam.args.paramHelpText",{defaultMessage:"The {URL} hash parameter to retrieve.",values:{URL:n.K}}),default:s.i18n.translate("xpack.canvas.functions.urlparam.args.defaultHelpText",{defaultMessage:"The string returned when the {URL} parameter is unspecified.",values:{URL:n.K}})}},Oe=()=>({all:l,alterColumn:r,any:c,as:u,asset:p,axisConfig:f,case:h,clear:T,columns:M,compare:y,containerStyle:w,context:H,csv:N,date:L,demodata:A,do:O,dropdownControl:I,eq:R,embeddable:B,escount:_,esdocs:P,exactly:U,filterrows:G,filters:V,formatdate:z,formatnumber:q,getCell:X,gt:Y,gte:j,head:J,if:Q,joinRows:$,location:Z,lt:ee,lte:ae,mapCenter:te,markdown:se,neq:ne,pie:le,plot:ie,ply:re,pointseries:ce,render:pe,replace:ge,rounddate:de,rowCount:fe,savedLens:me,savedMap:ve,savedSearch:xe,savedVisualization:he,seriesStyle:Te,sort:Me,staticColumn:ke,string:ye,switch:be,table:we,tail:Se,timefilter:He,timefilterControl:Ee,timelion:Le,timerange:De,to:Ce,urlparam:Fe}),Ie=()=>({alterColumn:o,asset:g,axisConfig:m,compare:b,containerStyle:S,csv:E,date:D,demodata:F,getCell:W,joinRows:K,ply:oe,pointseries:ue,timefilter:Ne,to:Ae})},129:function(e,a,t){"use strict";t.d(a,"a",(function(){return l})),t.d(a,"b",(function(){return i})),t.d(a,"c",(function(){return r})),t.d(a,"d",(function(){return o})),t.d(a,"e",(function(){return c}));var s=t(3),n=t(55);const l={AxisConfig:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.axisConfigTitle",{defaultMessage:"Axis config"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.axisConfigLabel",{defaultMessage:"Visualization axis configuration"}),getDisabledText:()=>s.i18n.translate("xpack.canvas.uis.arguments.axisConfigDisabledText",{defaultMessage:"Switch on to view axis settings"}),getPositionBottom:()=>s.i18n.translate("xpack.canvas.uis.arguments.axisConfig.position.options.bottomDropDown",{defaultMessage:"bottom"}),getPositionLabel:()=>s.i18n.translate("xpack.canvas.uis.arguments.axisConfig.positionLabel",{defaultMessage:"Position"}),getPositionLeft:()=>s.i18n.translate("xpack.canvas.uis.arguments.axisConfig.position.options.leftDropDown",{defaultMessage:"left"}),getPositionRight:()=>s.i18n.translate("xpack.canvas.uis.arguments.axisConfig.position.options.rightDropDown",{defaultMessage:"right"}),getPositionTop:()=>s.i18n.translate("xpack.canvas.uis.arguments.axisConfig.position.options.topDropDown",{defaultMessage:"top"})},DataColumn:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumnTitle",{defaultMessage:"Column"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumnLabel",{defaultMessage:"Select the data column"}),getOptionAverage:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.averageDropDown",{defaultMessage:"Average"}),getOptionCount:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.countDropDown",{defaultMessage:"Count"}),getOptionFirst:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.firstDropDown",{defaultMessage:"First"}),getOptionLast:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.lastDropDown",{defaultMessage:"Last"}),getOptionMax:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.maxDropDown",{defaultMessage:"Max"}),getOptionMedian:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.medianDropDown",{defaultMessage:"Median"}),getOptionMin:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.minDropDown",{defaultMessage:"Min"}),getOptionSum:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.sumDropDown",{defaultMessage:"Sum"}),getOptionUnique:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.uniqueDropDown",{defaultMessage:"Unique"}),getOptionValue:()=>s.i18n.translate("xpack.canvas.uis.arguments.dataColumn.options.valueDropDown",{defaultMessage:"Value"})},DateFormat:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.dateFormatTitle",{defaultMessage:"Date Format"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.dateFormatLabel",{defaultMessage:"Select or enter a {momentJS} format",values:{momentJS:n.v}})},FilterGroup:{getCreateNewGroup:()=>s.i18n.translate("xpack.canvas.uis.arguments.filterGroup.createNewGroupLinkText",{defaultMessage:"Create new group"}),getButtonSet:()=>s.i18n.translate("xpack.canvas.uis.arguments.filterGroup.setValue",{defaultMessage:"Set"}),getButtonCancel:()=>s.i18n.translate("xpack.canvas.uis.arguments.filterGroup.cancelValue",{defaultMessage:"Cancel"}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.filterGroupTitle",{defaultMessage:"Filter Group"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.filterGroupLabel",{defaultMessage:"Create or select a filter group"})},ImageUpload:{getAssetUrlType:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlTypes.assetDropDown",{defaultMessage:"Asset"}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUploadTitle",{defaultMessage:"Image upload"}),getFileUploadPrompt:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUpload.fileUploadPromptLabel",{defaultMessage:"Select or drag and drop an image"}),getFileUrlType:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlTypes.fileDropDown",{defaultMessage:"Import"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUploadLabel",{defaultMessage:"Select or upload an image"}),getImageUploading:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUpload.imageUploadingLabel",{defaultMessage:"Image uploading"}),getLinkUrlType:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlTypes.linkDropDown",{defaultMessage:"Link"}),getUrlFieldPlaceholder:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlFieldPlaceholder",{defaultMessage:"Image {url}",values:{url:n.K}}),getUrlTypeChangeLegend:()=>s.i18n.translate("xpack.canvas.uis.arguments.imageUpload.urlTypes.changeLegend",{defaultMessage:"Image upload type"})},Number:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberTitle",{defaultMessage:"Number"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberLabel",{defaultMessage:"Input a number"})},NumberFormat:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberFormatTitle",{defaultMessage:"Number Format"}),getFormatBytes:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.bytesDropDown",{defaultMessage:"Bytes"}),getFormatCurrency:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.currencyDropDown",{defaultMessage:"Currency"}),getFormatDuration:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.durationDropDown",{defaultMessage:"Duration"}),getFormatNumber:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.numberDropDown",{defaultMessage:"Number"}),getFormatPercent:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberFormat.format.percentDropDown",{defaultMessage:"Percent"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.numberFormatLabel",{defaultMessage:"Select or enter a valid {numeralJS} format",values:{numeralJS:n.x}})},Palette:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.paletteTitle",{defaultMessage:"Color palette"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.paletteLabel",{defaultMessage:"The collection of colors used to render the element"}),getCustomPaletteLabel:()=>s.i18n.translate("xpack.canvas.uis.arguments.customPaletteLabel",{defaultMessage:"Custom"})},Color:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.colorTitle",{defaultMessage:"Color"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.colorLabel",{defaultMessage:"Color picker"})},Percentage:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.percentageTitle",{defaultMessage:"Percentage"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.percentageLabel",{defaultMessage:"Slider for percentage "})},Range:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.rangeTitle",{defaultMessage:"Range"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.rangeLabel",{defaultMessage:"Slider for values within a range"})},Select:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.selectTitle",{defaultMessage:"Select"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.selectLabel",{defaultMessage:"Select from multiple options in a drop down"})},Shape:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.shapeTitle",{defaultMessage:"Shape"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.shapeLabel",{defaultMessage:"Change the shape of the current element"})},String:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.stringTitle",{defaultMessage:"String"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.stringLabel",{defaultMessage:"Input short strings"})},Textarea:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.textareaTitle",{defaultMessage:"Textarea"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.textareaLabel",{defaultMessage:"Input long strings"})},Toggle:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.toggleTitle",{defaultMessage:"Toggle"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.toggleLabel",{defaultMessage:"A true/false toggle switch"})},VisDimension:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.visDimensionTitle",{defaultMessage:"Column"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.visDimensionLabel",{defaultMessage:"Generates visConfig dimension object"}),getDefaultOptionName:()=>s.i18n.translate("xpack.canvas.uis.arguments.visDimensionDefaultOptionName",{defaultMessage:"Select column"})},StopsPalette:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.stopsPaletteTitle",{defaultMessage:"Palette picker with bounds"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.stopsPaletteLabel",{defaultMessage:"Provides colors for the values, based on the bounds"})},Editor:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.arguments.editorTitle",{defaultMessage:"Editor"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.arguments.editorLabel",{defaultMessage:"Provides a text area with syntax highlighting"})}},i={DemoData:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.dataSources.demoDataTitle",{defaultMessage:"Demo data"}),getHeading:()=>s.i18n.translate("xpack.canvas.uis.dataSources.demoData.headingTitle",{defaultMessage:"This element is using demo data"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.dataSources.demoDataLabel",{defaultMessage:"Sample data set used to populate default elements"}),getDescription:()=>s.i18n.translate("xpack.canvas.uis.dataSources.demoDataDescription",{defaultMessage:"By default, every {canvas} element is connected to the demo data source. Change the data source, above, to connect your own data.",values:{canvas:n.c}})},ESDocs:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocsTitle",{defaultMessage:"{elasticsearch} documents",values:{elasticsearch:n.i}}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocsLabel",{defaultMessage:"Pull data directly from {elasticsearch} without the use of aggregations",values:{elasticsearch:n.i}}),getWarningTitle:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.warningTitle",{defaultMessage:"Query with caution"}),getWarning:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.warningDescription",{defaultMessage:"\n        Using this data source with larger data sets can result in slower performance. Use this source only when you need exact values."}),getIndexTitle:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.indexTitle",{defaultMessage:"Index"}),getIndexLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.indexLabel",{defaultMessage:"Enter an index name or select a data view"}),getQueryTitle:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.queryTitle",{defaultMessage:"Query"}),getQueryLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.queryLabel",{defaultMessage:"{lucene} query string syntax",values:{lucene:n.s}}),getSortFieldTitle:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.sortFieldTitle",{defaultMessage:"Sort field"}),getSortFieldLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.sortFieldLabel",{defaultMessage:"Document sort field"}),getSortOrderTitle:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.sortOrderTitle",{defaultMessage:"Sort order"}),getSortOrderLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.sortOrderLabel",{defaultMessage:"Document sort order"}),getFieldsTitle:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.fieldsTitle",{defaultMessage:"Fields"}),getFieldsLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.fieldsLabel",{defaultMessage:"Scripted fields are unavailable"}),getFieldsWarningLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.fieldsWarningLabel",{defaultMessage:"This datasource performs best with 10 or fewer fields"}),getAscendingOption:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.ascendingDropDown",{defaultMessage:"Ascending"}),getDescendingOption:()=>s.i18n.translate("xpack.canvas.uis.dataSources.esdocs.descendingDropDown",{defaultMessage:"Descending"})},Essql:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.dataSources.essqlTitle",{defaultMessage:"{elasticsearch} {sql}",values:{elasticsearch:n.i,sql:n.A}}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.dataSources.essqlLabel",{defaultMessage:"Write an {elasticsearch} {sql} query to retrieve data",values:{elasticsearch:n.i,sql:n.A}}),getLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.essql.queryTitle",{defaultMessage:"Query"}),getLabelAppend:()=>s.i18n.translate("xpack.canvas.uis.dataSources.essql.queryTitleAppend",{defaultMessage:"Learn {elasticsearchShort} {sql} query syntax",values:{elasticsearchShort:n.j,sql:n.A}})},Timelion:{getAbout:()=>s.i18n.translate("xpack.canvas.uis.dataSources.timelion.aboutDetail",{defaultMessage:"Use {timelion} syntax in {canvas} to retrieve timeseries data",values:{timelion:n.C,canvas:n.c}}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.dataSources.timelionLabel",{defaultMessage:"Use {timelion} syntax to retrieve timeseries data",values:{timelion:n.C}}),getIntervalHelp:()=>s.i18n.translate("xpack.canvas.uis.dataSources.timelion.intervalLabel",{defaultMessage:"Use date math like {weeksExample}, {daysExample}, {secondsExample}, or {auto}",values:{secondsExample:"10s",daysExample:"5d",weeksExample:"1w",auto:"auto"}}),getIntervalLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.timelion.intervalTitle",{defaultMessage:"Interval"}),queryLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.timelion.queryLabel",{defaultMessage:"{timelion} Query String syntax",values:{timelion:n.C}}),getQueryLabel:()=>s.i18n.translate("xpack.canvas.uis.dataSources.timelion.queryTitle",{defaultMessage:"Query"}),getTipsHeading:()=>s.i18n.translate("xpack.canvas.uis.dataSources.timelion.tipsTitle",{defaultMessage:"Tips for using {timelion} in {canvas}",values:{timelion:n.C,canvas:n.c}})}},r={Math:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.mathTitle",{defaultMessage:"Measure"}),getValueDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.math.args.valueTitle",{defaultMessage:"Value"}),getValueHelp:()=>s.i18n.translate("xpack.canvas.uis.models.math.args.valueLabel",{defaultMessage:"Function and column to use in extracting a value from the datasource"})},PointSeries:{getColorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.colorTitle",{defaultMessage:"Color"}),getColorHelp:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.colorLabel",{defaultMessage:"Determines the color of a mark or series"}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeriesTitle",{defaultMessage:"Dimensions & measures"}),getSizeDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.sizeTitle",{defaultMessage:"Size"}),getSizeHelp:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.sizeLabel",{defaultMessage:"Determine the size of a mark"}),getTextDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.textTitle",{defaultMessage:"Text"}),getTextHelp:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.textLabel",{defaultMessage:"Set the text to use as, or around, the mark"}),getXAxisDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.xaxisTitle",{defaultMessage:"X-axis"}),getXAxisHelp:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.xaxisLabel",{defaultMessage:"Data along the horizontal axis. Usually a number, string or date"}),getYaxisDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.yaxisTitle",{defaultMessage:"Y-axis"}),getYaxisHelp:()=>s.i18n.translate("xpack.canvas.uis.models.pointSeries.args.yaxisLabel",{defaultMessage:"Data along the vertical axis. Usually a number"})},HeatmapLegend:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.title",{defaultMessage:"Configure the heatmap chart's legend"}),getIsVisibleDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.isVisibleTitle",{defaultMessage:"Show legend"}),getIsVisibleHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.isVisibleLabel",{defaultMessage:"Specifies whether or not the legend is visible"}),getPositionDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionTitle",{defaultMessage:"Legend Position"}),getPositionHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionLabel",{defaultMessage:"Specifies the legend position."}),getPositionTopOption:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionTopLabel",{defaultMessage:"Top"}),getPositionBottomOption:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionBottomLabel",{defaultMessage:"Bottom"}),getPositionLeftOption:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionLeftLabel",{defaultMessage:"Left"}),getPositionRightOption:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.positionRightLabel",{defaultMessage:"Right"}),getMaxLinesDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.maxLinesTitle",{defaultMessage:"Legend maximum lines"}),getMaxLinesHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.maxLinesLabel",{defaultMessage:"Specifies the number of lines per legend item."}),getShouldTruncateDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.shouldTruncateTitle",{defaultMessage:"Truncate label"}),getShouldTruncateHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_legend.args.shouldTruncateLabel",{defaultMessage:"Specifies whether or not the legend items should be truncated"})},HeatmapGrid:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.title",{defaultMessage:"Configure the heatmap layout"}),getStrokeWidthDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.strokeWidthTitle",{defaultMessage:"Stroke width"}),getStrokeWidthHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.strokeWidthLabel",{defaultMessage:"Specifies the grid stroke width"}),getStrokeColorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.strokeColorTitle",{defaultMessage:"Stroke color"}),getStrokeColorHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.strokeColorLabel",{defaultMessage:"Specifies the grid stroke color"}),getIsCellLabelVisibleDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isCellLabelVisibleTitle",{defaultMessage:"Show cell label"}),getIsCellLabelVisibleHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isCellLabelVisibleLabel",{defaultMessage:"Specifies whether or not the cell label is visible"}),getIsYAxisLabelVisibleDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isYAxisLabelVisibleTile",{defaultMessage:"Show Y-axis labels"}),getIsYAxisLabelVisibleHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isYAxisLabelVisibleLabel",{defaultMessage:"Specifies whether or not the Y-axis labels are visible"}),getIsYAxisTitleVisibleDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isYAxisTitleVisibleTile",{defaultMessage:"Show Y-axis title"}),getIsYAxisTitleVisibleHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isYAxisTitleVisibleLabel",{defaultMessage:"Specifies whether or not the Y-axis title is visible"}),getIsXAxisLabelVisibleDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isXAxisLabelVisibleTile",{defaultMessage:"Show X-axis labels"}),getIsXAxisLabelVisibleHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isXAxisLabelVisibleLabel",{defaultMessage:"Specifies whether or not the X-axis labels are visible"}),getIsXAxisTitleVisibleDisplayName:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isXAxisTitleVisibleTile",{defaultMessage:"Show X-axis title"}),getIsXAxisTitleVisibleHelp:()=>s.i18n.translate("xpack.canvas.uis.models.heatmap_grid.args.isXAxisTitleVisibleLabel",{defaultMessage:"Specifies whether or not the X-axis title is visible"})}},o={FormatDate:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.formatDateTitle",{defaultMessage:"Date format"}),getFormatDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.formatDate.args.formatTitle",{defaultMessage:"Format"})},FormatNumber:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.formatNumberTitle",{defaultMessage:"Number format"}),getFormatDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.formatNumber.args.formatTitle",{defaultMessage:"Format"})},RoundDate:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.roundDateTitle",{defaultMessage:"Round date"}),getFormatDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.roundDate.args.formatTitle",{defaultMessage:"Format"}),getFormatHelp:()=>s.i18n.translate("xpack.canvas.uis.transforms.roundDate.args.formatLabel",{defaultMessage:"Select or enter a {momentJs} format to round the date",values:{momentJs:n.v}})},Sort:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.sortTitle",{defaultMessage:"Datatable sorting"}),getReverseDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.sort.args.reverseToggleSwitch",{defaultMessage:"Descending"}),getSortFieldDisplayName:()=>s.i18n.translate("xpack.canvas.uis.transforms.sort.args.sortFieldTitle",{defaultMessage:"Sort field"})}},c={DropdownControl:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.dropdownControlTitle",{defaultMessage:"Dropdown filter"}),getFilterDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.filterColumnTitle",{defaultMessage:"Filter column"}),getFilterGroupDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.filterGroupTitle",{defaultMessage:"Filter group"}),getFilterGroupHelp:()=>s.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.filterGroupLabel",{defaultMessage:"Apply the selected group name to an element's filters function to target this filter"}),getFilterHelp:()=>s.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.filterColumnLabel",{defaultMessage:"Column to which the value selected from the dropdown is applied"}),getValueDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.valueColumnTitle",{defaultMessage:"Value column"}),getValueHelp:()=>s.i18n.translate("xpack.canvas.uis.views.dropdownControl.args.valueColumnLabel",{defaultMessage:"Column from which to extract values to make available in the dropdown"})},GetCell:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.getCellTitle",{defaultMessage:"Dropdown filter"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.views.getCellLabel",{defaultMessage:"Grab the first row and first column"})},Image:{getContainMode:()=>s.i18n.translate("xpack.canvas.uis.views.image.args.mode.containDropDown",{defaultMessage:"Contain"}),getCoverMode:()=>s.i18n.translate("xpack.canvas.uis.views.image.args.mode.coverDropDown",{defaultMessage:"Cover"}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.imageTitle",{defaultMessage:"Image"}),getModeDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.image.args.modeTitle",{defaultMessage:"Fill mode"}),getModeHelp:()=>s.i18n.translate("xpack.canvas.uis.views.image.args.modeLabel",{defaultMessage:"Note: Stretched fill may not work with vector images"}),getStretchMode:()=>s.i18n.translate("xpack.canvas.uis.views.image.args.mode.stretchDropDown",{defaultMessage:"Stretch"})},Markdown:{getContentDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.markdown.args.contentTitle",{defaultMessage:"{markdown} content",values:{markdown:n.u}}),getContentHelp:()=>s.i18n.translate("xpack.canvas.uis.views.markdown.args.contentLabel",{defaultMessage:"{markdown} formatted text",values:{markdown:n.u}}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.markdownTitle",{defaultMessage:"{markdown}",values:{markdown:n.u}}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.views.markdownLabel",{defaultMessage:"Generate markup using {markdown}",values:{markdown:n.u}}),getOpenLinksInNewTabDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.openLinksInNewTabTitle",{defaultMessage:"Markdown link settings"}),getOpenLinksInNewTabLabelName:()=>s.i18n.translate("xpack.canvas.uis.views.openLinksInNewTabLabel",{defaultMessage:"Open all links in a new tab"}),getOpenLinksInNewTabHelp:()=>s.i18n.translate("xpack.canvas.uis.views.openLinksInNewTabHelpLabel",{defaultMessage:"Set links to open in new tab"})},Metric:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metricTitle",{defaultMessage:"Metric"}),getNumberDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.numberArgTitle",{defaultMessage:"Value"}),getLabelDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metric.args.labelArgTitle",{defaultMessage:"Label"}),getLabelFontDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metric.args.labelFontTitle",{defaultMessage:"Label text"}),getLabelFontHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metric.args.labelFontLabel",{defaultMessage:"Fonts, alignment and color"}),getLabelHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metric.args.labelArgLabel",{defaultMessage:"Enter a text label for the metric value"}),getMetricFontDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metric.args.metricFontTitle",{defaultMessage:"Metric text"}),getMetricFontHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metric.args.metricFontLabel",{defaultMessage:"Fonts, alignment and color"}),getMetricFormatDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metric.args.metricFormatTitle",{defaultMessage:"Format"}),getMetricFormatHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metric.args.metricFormatLabel",{defaultMessage:"Select a format for the metric value"})},Pie:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.pieTitle",{defaultMessage:"Chart style"}),getHoleDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.holeTitle",{defaultMessage:"Inner radius"}),getHoleHelp:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.holeLabel",{defaultMessage:"Radius of the hole"}),getLabelRadiusDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.labelRadiusTitle",{defaultMessage:"Label radius"}),getLabelRadiusHelp:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.labelRadiusLabel",{defaultMessage:"Distance of the labels from the center of the pie"}),getLabelsDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.labelsTitle",{defaultMessage:"Labels"}),getLabelsToggleSwitch:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.labelsToggleSwitch",{defaultMessage:"Show labels"}),getLabelsHelp:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.labelsLabel",{defaultMessage:"Show/hide labels"}),getLegendDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.legendTitle",{defaultMessage:"Legend"}),getLegendHelp:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.legendLabel",{defaultMessage:"Disable or position the legend"}),getRadiusDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.radiusTitle",{defaultMessage:"Radius"}),getRadiusHelp:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.radiusLabel",{defaultMessage:"Radius of the pie"}),getTiltDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.tiltTitle",{defaultMessage:"Tilt angle"}),getTiltHelp:()=>s.i18n.translate("xpack.canvas.uis.views.pie.args.tiltLabel",{defaultMessage:"Percentage of tilt where 100 is fully vertical and 0 is completely flat"})},Plot:{getDefaultStyleDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.plot.args.defaultStyleTitle",{defaultMessage:"Default style"}),getDefaultStyleHelp:()=>s.i18n.translate("xpack.canvas.uis.views.plot.args.defaultStyleLabel",{defaultMessage:"Set the style to be used by default by every series, unless overridden"}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.plotTitle",{defaultMessage:"Chart style"}),getLegendDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.plot.args.legendTitle",{defaultMessage:"Legend"}),getLegendHelp:()=>s.i18n.translate("xpack.canvas.uis.views.plot.args.legendLabel",{defaultMessage:"Disable or position the legend"}),getXaxisDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.plot.args.xaxisTitle",{defaultMessage:"X-axis"}),getXaxisHelp:()=>s.i18n.translate("xpack.canvas.uis.views.plot.args.xaxisLabel",{defaultMessage:"Configure or disable the x-axis"}),getYaxisDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.plot.args.yaxisTitle",{defaultMessage:"Y-axis"}),getYaxisHelp:()=>s.i18n.translate("xpack.canvas.uis.views.plot.args.yaxisLabel",{defaultMessage:"Configure or disable the Y-axis"})},Progress:{getBarColorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.barColorTitle",{defaultMessage:"Background color"}),getBarColorHelp:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.barColorLabel",{defaultMessage:"Accepts HEX, RGB or HTML color names"}),getBarWeightDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.barWeightTitle",{defaultMessage:"Background weight"}),getBarWeightHelp:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.barWeightLabel",{defaultMessage:"Thickness of the background bar"}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progressTitle",{defaultMessage:"Progress"}),getFontDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.fontTitle",{defaultMessage:"Label settings"}),getFontHelp:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.fontLabel",{defaultMessage:"Font settings for the label. Technically, you can add other styles as well"}),getLabelDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.labelArgTitle",{defaultMessage:"Label"}),getLabelHelp:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.labelArgLabel",{defaultMessage:"Set {true}/{false} to show/hide label or provide a string to display as the label",values:{true:n.b,false:n.a}}),getMaxDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.maxTitle",{defaultMessage:"Maximum value"}),getMaxHelp:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.maxLabel",{defaultMessage:"Maximum value of the progress element"}),getShapeDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.shapeTitle",{defaultMessage:"Shape"}),getShapeHelp:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.shapeLabel",{defaultMessage:"Shape of the progress indicator"}),getValueColorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.valueColorTitle",{defaultMessage:"Progress color"}),getValueColorHelp:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.valueColorLabel",{defaultMessage:"Accepts {hex}, {rgb} or {html} Color names",values:{html:n.n,hex:n.m,rgb:n.z}}),getValueWeightDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.valueWeightTitle",{defaultMessage:"Progress weight"}),getValueWeightHelp:()=>s.i18n.translate("xpack.canvas.uis.views.progress.args.valueWeightLabel",{defaultMessage:"Thickness of the progress bar"})},Render:{getCssApply:()=>s.i18n.translate("xpack.canvas.uis.views.render.args.css.applyButtonLabel",{defaultMessage:"Apply Stylesheet"}),getCssHelp:()=>s.i18n.translate("xpack.canvas.uis.views.render.args.cssLabel",{defaultMessage:"A {css} stylesheet scoped to your element",values:{css:n.e}}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.renderTitle",{defaultMessage:"Element style"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.views.renderLabel",{defaultMessage:"Setting for the container around your element"})},RepeatImage:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImageTitle",{defaultMessage:"Repeating image"}),getEmptyImageDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImage.args.emptyImageTitle",{defaultMessage:"Empty image"}),getEmptyImageHelp:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImage.args.emptyImageLabel",{defaultMessage:"An image to fill up the difference between the value and the max count"}),getImageDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImage.args.imageTitle",{defaultMessage:"Image"}),getImageHelp:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImage.args.imageLabel",{defaultMessage:"An image to repeat"}),getMaxDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImage.args.maxTitle",{defaultMessage:"Max count"}),getMaxHelp:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImage.args.maxLabel",{defaultMessage:"The maximum number of repeated images"}),getSizeDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImage.args.sizeTitle",{defaultMessage:"Image size"}),getSizeHelp:()=>s.i18n.translate("xpack.canvas.uis.views.repeatImage.args.sizeLabel",{defaultMessage:"The size of the largest dimension of the image. Eg, if the image is tall but not wide, this is the height"})},RevealImage:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.revealImageTitle",{defaultMessage:"Reveal image"}),getEmptyImageDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.emptyImageTitle",{defaultMessage:"Background image"}),getEmptyImageHelp:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.emptyImageLabel",{defaultMessage:"A background image. Eg, an empty glass"}),getImageDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.imageTitle",{defaultMessage:"Image"}),getImageHelp:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.imageLabel",{defaultMessage:"An image to reveal given the function input. Eg, a full glass"}),getOriginBottom:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.origin.bottomDropDown",{defaultMessage:"Bottom"}),getOriginDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.originTitle",{defaultMessage:"Reveal from"}),getOriginHelp:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.originLabel",{defaultMessage:"The direction from which to start the reveal"}),getOriginLeft:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.origin.leftDropDown",{defaultMessage:"Left"}),getOriginRight:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.origin.rightDropDown",{defaultMessage:"Right"}),getOriginTop:()=>s.i18n.translate("xpack.canvas.uis.views.revealImage.args.origin.topDropDown",{defaultMessage:"Top"})},Shape:{getBorderDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.borderTitle",{defaultMessage:"Border"}),getBorderHelp:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.borderLabel",{defaultMessage:"Accepts HEX, RGB or HTML color names"}),getBorderWidthDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.borderWidthTitle",{defaultMessage:"Border width"}),getBorderWidthHelp:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.borderWidthLabel",{defaultMessage:"Border width"}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.shapeTitle",{defaultMessage:"Shape"}),getFillDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.fillTitle",{defaultMessage:"Fill"}),getFillHelp:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.fillLabel",{defaultMessage:"Accepts HEX, RGB or HTML color names"}),getMaintainAspectDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.maintainAspectTitle",{defaultMessage:"Aspect ratio settings"}),getMaintainAspectLabelName:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.maintainAspectLabel",{defaultMessage:"Use a fixed ratio"}),getMaintainAspectHelp:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.maintainAspectHelpLabel",{defaultMessage:"Enable to maintain aspect ratio"}),getShapeDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.shape.args.shapeTitle",{defaultMessage:"Select shape"})},Table:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tableTitle",{defaultMessage:"Table style"}),getHelp:()=>s.i18n.translate("xpack.canvas.uis.views.tableLabel",{defaultMessage:"Set styling for a Table element"}),getPaginateDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.table.args.paginateTitle",{defaultMessage:"Pagination"}),getPaginateToggleSwitch:()=>s.i18n.translate("xpack.canvas.uis.views.table.args.paginateToggleSwitch",{defaultMessage:"Show pagination controls"}),getPaginateHelp:()=>s.i18n.translate("xpack.canvas.uis.views.table.args.paginateLabel",{defaultMessage:"Show or hide pagination controls. If disabled only the first page will be shown"}),getPerPageDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.table.args.perPageTitle",{defaultMessage:"Rows"}),getPerPageHelp:()=>s.i18n.translate("xpack.canvas.uis.views.table.args.perPageLabel",{defaultMessage:"Number of rows to display per table page"}),getShowHeaderDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.table.args.showHeaderTitle",{defaultMessage:"Header"}),getShowHeaderToggleSwitch:()=>s.i18n.translate("xpack.canvas.uis.views.table.args.showHeaderToggleSwitch",{defaultMessage:"Show the header row"}),getShowHeaderHelp:()=>s.i18n.translate("xpack.canvas.uis.views.table.args.showHeaderLabel",{defaultMessage:"Show or hide the header row with titles for each column"})},Timefilter:{getColumnConfirm:()=>s.i18n.translate("xpack.canvas.uis.views.timefilter.args.columnConfirmButtonLabel",{defaultMessage:"Set"}),getColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.timefilter.args.columnTitle",{defaultMessage:"Column"}),getColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.timefilter.args.columnLabel",{defaultMessage:"Column to which selected time is applied"}),getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.timefilterTitle",{defaultMessage:"Time filter"}),getFilterGroupDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.timefilter.args.filterGroupTitle",{defaultMessage:"Filter group"}),getFilterGroupHelp:()=>s.i18n.translate("xpack.canvas.uis.views.timefilter.args.filterGroupLabel",{defaultMessage:"Apply the selected group name to an element's filters function to target this filter"})},Tagcloud:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloudTitle",{defaultMessage:"Tag Cloud"}),getScaleColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleDisplayName",{defaultMessage:"Scale"}),getScaleColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleHelp",{defaultMessage:"Scale to determine font size of a word"}),getScaleLinear:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleLinearLabel",{defaultMessage:"Linear"}),getScaleLog:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleLogLabel",{defaultMessage:"Log"}),getScaleSquareRoot:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.scaleSquareRootLabel",{defaultMessage:"Square root"}),getOrientationColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationDisplayName",{defaultMessage:"Orientation"}),getOrientationColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationHelp",{defaultMessage:"Orientation of words inside tagcloud"}),getOrientationSingle:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationSingleLabel",{defaultMessage:"Single"}),getOrientationRightAngled:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationRightAngledLabel",{defaultMessage:"Right angled"}),getOrientationMultiple:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.orientationMultipleLabel",{defaultMessage:"Multiple"}),getMinFontHeightColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.minFontHeightDisplayName",{defaultMessage:"Minimum font height"}),getMinFontHeightColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.minFontHeightHelp",{defaultMessage:"Minimum height of the element font"}),getMaxFontHeightColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.maxFontHeightDisplayName",{defaultMessage:"Maximum font height"}),getMaxFontHeightColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.maxFontHeightHelp",{defaultMessage:"Maximum height of the element font"}),getShowLabelColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.showLabelDisplayName",{defaultMessage:"Show label"}),getShowLabelColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.showLabelHelp",{defaultMessage:"Show label of the chart"}),getMetricColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.metricDisplayName",{defaultMessage:"Metric"}),getMetricColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.metricHelp",{defaultMessage:"Metric dimension configuration"}),getBucketColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.bucketDisplayName",{defaultMessage:"Bucket"}),getBucketColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.tagcloud.args.bucketHelp",{defaultMessage:"Bucket dimension configuration"})},MetricVis:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metricVisTitle",{defaultMessage:"Metric Vis"}),getMetricColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.metricDisplayName",{defaultMessage:"Metric"}),getMetricColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.metricHelp",{defaultMessage:"Metric dimension configuration"}),getBucketColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.bucketDisplayName",{defaultMessage:"Bucket"}),getBucketColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.bucketHelp",{defaultMessage:"Bucket dimension configuration"}),getFontColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.fontDisplayName",{defaultMessage:"Font"}),getFontColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.fontHelp",{defaultMessage:"Metric font configuration"}),getPercentageModeColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.percentageModeDisplayName",{defaultMessage:"Enable percentage mode"}),getPercentageModeColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.percentageModeHelp",{defaultMessage:"Shows metric in percentage mode."}),getShowLabelsColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.showLabelsDisplayName",{defaultMessage:"Show metric labels"}),getShowLabelsColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.showLabelsHelp",{defaultMessage:"Shows labels under the metric values."}),getColorModeColumnDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorModeDisplayName",{defaultMessage:"Metric color mode"}),getColorModeColumnHelp:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorModeHelp",{defaultMessage:"Which part of metric to fill with color."}),getColorModeNoneOption:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorMode.noneOption",{defaultMessage:"None"}),getColorModeLabelOption:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorMode.labelsOption",{defaultMessage:"Labels"}),getColorModeBackgroundOption:()=>s.i18n.translate("xpack.canvas.uis.views.metricVis.args.colorMode.backgroundOption",{defaultMessage:"Background"})},Heatmap:{getDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmapTitle",{defaultMessage:"Heatmap Visualization"}),getXAccessorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.xAccessorDisplayName",{defaultMessage:"X-axis"}),getXAccessorHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.xAccessorHelp",{defaultMessage:"The name of the x axis column or the corresponding dimension"}),getYAccessorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.yAccessorDisplayName",{defaultMessage:"Y-axis"}),getYAccessorHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.yAccessorHelp",{defaultMessage:"The name of the y axis column or the corresponding dimension"}),getValueAccessorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.valueAccessorDisplayName",{defaultMessage:"Value"}),getValueAccessorHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.valueAccessorHelp",{defaultMessage:"The name of the value column or the corresponding dimension"}),getLegendHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.legendHelp",{defaultMessage:"Configure the heatmap chart's legend"}),getLegendDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.legendDisplayName",{defaultMessage:"Heatmap legend"}),getGridConfigHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.gridConfigHelp",{defaultMessage:"Configure the heatmap layout"}),getGridConfigDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.gridConfigDisplayName",{defaultMessage:"Heatmap layout configuration"}),getSplitRowAccessorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.splitRowAccessorDisplayName",{defaultMessage:"Split row"}),getSplitRowAccessorHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.plitRowAccessorHelp",{defaultMessage:"The id of the split row or the corresponding dimension"}),getSplitColumnAccessorDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.splitColumnAccessorDisplayName",{defaultMessage:"Split column"}),getSplitColumnAccessorHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.splitColumnAccessorHelp",{defaultMessage:"The id of the split column or the corresponding dimension"}),getShowTooltipDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.showTooltipDisplayName",{defaultMessage:"Show tooltip"}),getShowTooltipHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.showTooltipHelp",{defaultMessage:"Show tooltip on hover"}),getHighlightInHoverDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.highlightInHoverDisplayName",{defaultMessage:"Hightlight on hover"}),getHighlightInHoverHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.highlightInHoverHelp",{defaultMessage:"When this is enabled, it highlights the ranges of the same color on legend hover"}),getLastRangeIsRightOpenDisplayName:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.lastRangeIsRightOpenDisplayName",{defaultMessage:"Last range is right open"}),getLastRangeIsRightOpenHelp:()=>s.i18n.translate("xpack.canvas.uis.views.heatmap.args.lastRangeIsRightOpenHelp",{defaultMessage:"If is set to true, the last range value will be right open"})}}},130:function(e,a,t){"use strict";t.d(a,"a",(function(){return n}));var s=t(3);const n={time:{getCycleTimeText:(e,a)=>{switch(a){case"seconds":return s.i18n.translate("xpack.canvas.workpadHeader.cycleIntervalSecondsText",{defaultMessage:"Every {seconds} {seconds, plural, one {second} other {seconds}}",values:{seconds:e}});case"minutes":return s.i18n.translate("xpack.canvas.workpadHeader.cycleIntervalMinutesText",{defaultMessage:"Every {minutes} {minutes, plural, one {minute} other {minutes}}",values:{minutes:e}});case"hours":return s.i18n.translate("xpack.canvas.workpadHeader.cycleIntervalHoursText",{defaultMessage:"Every {hours} {hours, plural, one {hour} other {hours}}",values:{hours:e}});case"days":return s.i18n.translate("xpack.canvas.workpadHeader.cycleIntervalDaysText",{defaultMessage:"Every {days} {days, plural, one {day} other {days}}",values:{days:e}})}},getDaysText:e=>s.i18n.translate("xpack.canvas.units.time.days",{defaultMessage:"{days, plural, one {# day} other {# days}}",values:{days:e}}),getHoursText:e=>s.i18n.translate("xpack.canvas.units.time.hours",{defaultMessage:"{hours, plural, one {# hour} other {# hours}}",values:{hours:e}}),getMinutesText:e=>s.i18n.translate("xpack.canvas.units.time.minutes",{defaultMessage:"{minutes, plural, one {# minute} other {# minutes}}",values:{minutes:e}}),getSecondsText:e=>s.i18n.translate("xpack.canvas.units.time.seconds",{defaultMessage:"{seconds, plural, one {# second} other {# seconds}}",values:{seconds:e}})},quickRanges:{getYesterdayLabel:()=>s.i18n.translate("xpack.canvas.units.quickRange.yesterday",{defaultMessage:"Yesterday"}),getTodayLabel:()=>s.i18n.translate("xpack.canvas.units.quickRange.today",{defaultMessage:"Today"}),getLast24HoursLabel:()=>s.i18n.translate("xpack.canvas.units.quickRange.last24Hours",{defaultMessage:"Last 24 hours"}),getLast7DaysLabel:()=>s.i18n.translate("xpack.canvas.units.quickRange.last7Days",{defaultMessage:"Last 7 days"}),getLast2WeeksLabel:()=>s.i18n.translate("xpack.canvas.units.quickRange.last2Weeks",{defaultMessage:"Last 2 weeks"}),getLast30DaysLabel:()=>s.i18n.translate("xpack.canvas.units.quickRange.last30Days",{defaultMessage:"Last 30 days"}),getLast90DaysLabel:()=>s.i18n.translate("xpack.canvas.units.quickRange.last90Days",{defaultMessage:"Last 90 days"}),getLast1YearLabel:()=>s.i18n.translate("xpack.canvas.units.quickRange.last1Year",{defaultMessage:"Last 1 year"})}}},159:function(e,a,t){"use strict";t.d(a,"a",(function(){return s})),t.d(a,"b",(function(){return l}));const s=e=>{const a=l();return e.map((e=>{const t=e(),{name:s}=t,n=a[s];if(n){const{displayName:e,help:a}=n;a&&(t.help=a),e&&(t.displayName=e)}return()=>t}))};var n=t(3);const l=()=>({areaChart:{displayName:n.i18n.translate("xpack.canvas.elements.areaChartDisplayName",{defaultMessage:"Area"}),help:n.i18n.translate("xpack.canvas.elements.areaChartHelpText",{defaultMessage:"A line chart with a filled body"})},bubbleChart:{displayName:n.i18n.translate("xpack.canvas.elements.bubbleChartDisplayName",{defaultMessage:"Bubble"}),help:n.i18n.translate("xpack.canvas.elements.bubbleChartHelpText",{defaultMessage:"A customizable bubble chart"})},debug:{displayName:n.i18n.translate("xpack.canvas.elements.debugDisplayName",{defaultMessage:"Debug data"}),help:n.i18n.translate("xpack.canvas.elements.debugHelpText",{defaultMessage:"Just dumps the configuration of the element"})},dropdownFilter:{displayName:n.i18n.translate("xpack.canvas.elements.dropdownFilterDisplayName",{defaultMessage:"Dropdown select"}),help:n.i18n.translate("xpack.canvas.elements.dropdownFilterHelpText",{defaultMessage:'A dropdown from which you can select values for an "exactly" filter'})},filterDebug:{displayName:n.i18n.translate("xpack.canvas.elements.filterDebugDisplayName",{defaultMessage:"Debug filters"}),help:n.i18n.translate("xpack.canvas.elements.filterDebugHelpText",{defaultMessage:"Shows the underlying global filters in a workpad"})},horizontalBarChart:{displayName:n.i18n.translate("xpack.canvas.elements.horizontalBarChartDisplayName",{defaultMessage:"Horizontal bar"}),help:n.i18n.translate("xpack.canvas.elements.horizontalBarChartHelpText",{defaultMessage:"A customizable horizontal bar chart"})},horizontalProgressBar:{displayName:n.i18n.translate("xpack.canvas.elements.horizontalProgressBarDisplayName",{defaultMessage:"Horizontal bar"}),help:n.i18n.translate("xpack.canvas.elements.horizontalProgressBarHelpText",{defaultMessage:"Displays progress as a portion of a horizontal bar"})},horizontalProgressPill:{displayName:n.i18n.translate("xpack.canvas.elements.horizontalProgressPillDisplayName",{defaultMessage:"Horizontal pill"}),help:n.i18n.translate("xpack.canvas.elements.horizontalProgressPillHelpText",{defaultMessage:"Displays progress as a portion of a horizontal pill"})},image:{displayName:n.i18n.translate("xpack.canvas.elements.imageDisplayName",{defaultMessage:"Image"}),help:n.i18n.translate("xpack.canvas.elements.imageHelpText",{defaultMessage:"A static image"})},lineChart:{displayName:n.i18n.translate("xpack.canvas.elements.lineChartDisplayName",{defaultMessage:"Line"}),help:n.i18n.translate("xpack.canvas.elements.lineChartHelpText",{defaultMessage:"A customizable line chart"})},markdown:{displayName:n.i18n.translate("xpack.canvas.elements.markdownDisplayName",{defaultMessage:"Text"}),help:n.i18n.translate("xpack.canvas.elements.markdownHelpText",{defaultMessage:"Add text using Markdown"})},metric:{displayName:n.i18n.translate("xpack.canvas.elements.metricDisplayName",{defaultMessage:"Metric"}),help:n.i18n.translate("xpack.canvas.elements.metricHelpText",{defaultMessage:"A number with a label"})},pie:{displayName:n.i18n.translate("xpack.canvas.elements.pieDisplayName",{defaultMessage:"Pie"}),help:n.i18n.translate("xpack.canvas.elements.pieHelpText",{defaultMessage:"Pie chart"})},plot:{displayName:n.i18n.translate("xpack.canvas.elements.plotDisplayName",{defaultMessage:"Coordinate plot"}),help:n.i18n.translate("xpack.canvas.elements.plotHelpText",{defaultMessage:"Mixed line, bar or dot charts"})},progressGauge:{displayName:n.i18n.translate("xpack.canvas.elements.progressGaugeDisplayName",{defaultMessage:"Gauge"}),help:n.i18n.translate("xpack.canvas.elements.progressGaugeHelpText",{defaultMessage:"Displays progress as a portion of a gauge"})},progressSemicircle:{displayName:n.i18n.translate("xpack.canvas.elements.progressSemicircleDisplayName",{defaultMessage:"Semicircle"}),help:n.i18n.translate("xpack.canvas.elements.progressSemicircleHelpText",{defaultMessage:"Displays progress as a portion of a semicircle"})},progressWheel:{displayName:n.i18n.translate("xpack.canvas.elements.progressWheelDisplayName",{defaultMessage:"Wheel"}),help:n.i18n.translate("xpack.canvas.elements.progressWheelHelpText",{defaultMessage:"Displays progress as a portion of a wheel"})},repeatImage:{displayName:n.i18n.translate("xpack.canvas.elements.repeatImageDisplayName",{defaultMessage:"Image repeat"}),help:n.i18n.translate("xpack.canvas.elements.repeatImageHelpText",{defaultMessage:"Repeats an image N times"})},revealImage:{displayName:n.i18n.translate("xpack.canvas.elements.revealImageDisplayName",{defaultMessage:"Image reveal"}),help:n.i18n.translate("xpack.canvas.elements.revealImageHelpText",{defaultMessage:"Reveals a percentage of an image"})},shape:{displayName:n.i18n.translate("xpack.canvas.elements.shapeDisplayName",{defaultMessage:"Shape"}),help:n.i18n.translate("xpack.canvas.elements.shapeHelpText",{defaultMessage:"A customizable shape"})},table:{displayName:n.i18n.translate("xpack.canvas.elements.tableDisplayName",{defaultMessage:"Data table"}),help:n.i18n.translate("xpack.canvas.elements.tableHelpText",{defaultMessage:"A scrollable grid for displaying data in a tabular format"})},timeFilter:{displayName:n.i18n.translate("xpack.canvas.elements.timeFilterDisplayName",{defaultMessage:"Time filter"}),help:n.i18n.translate("xpack.canvas.elements.timeFilterHelpText",{defaultMessage:"Set a time window"})},verticalBarChart:{displayName:n.i18n.translate("xpack.canvas.elements.verticalBarChartDisplayName",{defaultMessage:"Vertical bar"}),help:n.i18n.translate("xpack.canvas.elements.verticalBarChartHelpText",{defaultMessage:"A customizable vertical bar chart"})},verticalProgressBar:{displayName:n.i18n.translate("xpack.canvas.elements.verticalProgressBarDisplayName",{defaultMessage:"Vertical bar"}),help:n.i18n.translate("xpack.canvas.elements.verticalProgressBarHelpText",{defaultMessage:"Displays progress as a portion of a vertical bar"})},verticalProgressPill:{displayName:n.i18n.translate("xpack.canvas.elements.verticalProgressPillDisplayName",{defaultMessage:"Vertical pill"}),help:n.i18n.translate("xpack.canvas.elements.verticalProgressPillHelpText",{defaultMessage:"Displays progress as a portion of a vertical pill"})},tagCloud:{displayName:n.i18n.translate("xpack.canvas.elements.tagCloudDisplayName",{defaultMessage:"Tag Cloud"}),help:n.i18n.translate("xpack.canvas.elements.tagCloudHelpText",{defaultMessage:"Tagcloud visualization"})},metricVis:{displayName:n.i18n.translate("xpack.canvas.elements.metricVisDisplayName",{defaultMessage:"Metric"}),help:n.i18n.translate("xpack.canvas.elements.metricVisHelpText",{defaultMessage:"Metric visualization"})},legacyMetricVis:{displayName:n.i18n.translate("xpack.canvas.elements.legacyMetricVisDisplayName",{defaultMessage:"Legacy Metric Vis"}),help:n.i18n.translate("xpack.canvas.elements.legacyMetricVisHelpText",{defaultMessage:"Legacy metric visualization. We recommend using metricVis instead."})},heatmap:{displayName:n.i18n.translate("xpack.canvas.elements.heatmapDisplayName",{defaultMessage:"Heatmap"}),help:n.i18n.translate("xpack.canvas.elements.heatmapHelpText",{defaultMessage:"Heatmap visualization"})}})},161:function(e,a,t){},162:function(e,a,t){},163:function(e,a,t){},164:function(e,a,t){},165:function(e,a,t){"use strict";let s;t.d(a,"a",(function(){return s})),function(e){e.luceneQueryString="luceneQueryString",e.time="time",e.exactly="exactly"}(s||(s={}))},166:function(e,a,t){"use strict";let s,n;t.d(a,"a",(function(){return s})),t.d(a,"b",(function(){return n})),t.d(a,"c",(function(){return l})),function(e){e.NORTH_WEST="nw",e.SOUTH_WEST="sw",e.NORTH_EAST="ne",e.SOUTH_EAST="se"}(s||(s={})),function(e){e.TOP="top",e.BOTTOM="bottom",e.LEFT="left",e.RIGHT="right"}(n||(n={}));const l=e=>!!e&&"axisConfig"===e.type},167:function(e,a,t){},168:function(e,a,t){},169:function(e,a,t){"use strict";let s;!function(e){e.FULLSCREEN="__fullscreen",e.REFRESH_INTERVAL="__refreshInterval",e.AUTOPLAY_INTERVAL="__autoplayInterval"}(s||(s={}))},170:function(e,a,t){},171:function(e,a,t){"use strict";let s;t.d(a,"a",(function(){return s})),t.d(a,"b",(function(){return n})),function(e){e.NONE="none",e.SOLID="solid",e.DOTTED="dotted",e.DASHED="dashed",e.DOUBLE="double",e.GROOVE="groove",e.RIDGE="ridge",e.INSET="inset",e.OUTSET="outset"}(s||(s={}));const n=e=>!!e&&Object.values(s).includes(e)},172:function(e,a,t){},173:function(e,a,t){"use strict";t.d(a,"a",(function(){return n})),t.d(a,"b",(function(){return l}));var s=t(54);let n;function l(){const{help:e,args:a}=Object(s.u)().compare,t=Object(s.t)().compare;return{name:"compare",help:e,aliases:["condition"],type:"boolean",inputTypes:["string","number","boolean","null"],args:{op:{aliases:["_"],types:["string"],default:"eq",help:a.op,options:Object.values(n)},to:{aliases:["this","b"],help:a.to}},fn:(e,a)=>{const s=e,{to:l,op:i}=a,r=typeof s==typeof l;switch(i){case n.EQ:return s===l;case n.NE:case n.NEQ:return s!==l;case n.LT:return!!r&&s<l;case n.LTE:return!!r&&s<=l;case n.GT:return!!r&&s>l;case n.GTE:return!!r&&s>=l;default:throw t.invalidCompareOperator(i,Object.values(n).join(", "))}}}}!function(e){e.EQ="eq",e.GT="gt",e.GTE="gte",e.LT="lt",e.LTE="lte",e.NE="ne",e.NEQ="neq"}(n||(n={}))},54:function(e,a,t){"use strict";t.d(a,"d",(function(){return l})),t.d(a,"c",(function(){return n.c})),t.d(a,"g",(function(){return n.t})),t.d(a,"k",(function(){return n.B})),t.d(a,"l",(function(){return n.C})),t.d(a,"m",(function(){return n.D})),t.d(a,"f",(function(){return i})),t.d(a,"a",(function(){return r})),t.d(a,"s",(function(){return o.b})),t.d(a,"u",(function(){return c.b})),t.d(a,"t",(function(){return c.a})),t.d(a,"h",(function(){return u})),t.d(a,"j",(function(){return p})),t.d(a,"n",(function(){return g})),t.d(a,"p",(function(){return d})),t.d(a,"b",(function(){return f.a})),t.d(a,"e",(function(){return f.b})),t.d(a,"i",(function(){return f.c})),t.d(a,"o",(function(){return f.d})),t.d(a,"r",(function(){return f.e})),t.d(a,"q",(function(){return m.a}));var s=t(3),n=t(55);const l={ReadOnlyBadge:{getText:()=>s.i18n.translate("xpack.canvas.badge.readOnly.text",{defaultMessage:"Read only"}),getTooltip:()=>s.i18n.translate("xpack.canvas.badge.readOnly.tooltip",{defaultMessage:"Unable to save {canvas} workpads",values:{canvas:n.c}})}},i={actionsElements:{getInvalidArgIndexErrorMessage:e=>s.i18n.translate("xpack.canvas.error.actionsElements.invaludArgIndexErrorMessage",{defaultMessage:"Invalid argument index: {index}",values:{index:e}})},esPersist:{getSaveFailureTitle:()=>s.i18n.translate("xpack.canvas.error.esPersist.saveFailureTitle",{defaultMessage:"Couldn't save your changes to Elasticsearch"}),getTooLargeErrorMessage:()=>s.i18n.translate("xpack.canvas.error.esPersist.tooLargeErrorMessage",{defaultMessage:"The server gave a response that the workpad data was too large. This usually means uploaded image assets that are too large for Kibana or a proxy. Try removing some assets in the asset manager."}),getUpdateFailureTitle:()=>s.i18n.translate("xpack.canvas.error.esPersist.updateFailureTitle",{defaultMessage:"Couldn't update workpad"})},esService:{getDefaultIndexFetchErrorMessage:()=>s.i18n.translate("xpack.canvas.error.esService.defaultIndexFetchErrorMessage",{defaultMessage:"Couldn't fetch default index"}),getFieldsFetchErrorMessage:e=>s.i18n.translate("xpack.canvas.error.esService.fieldsFetchErrorMessage",{defaultMessage:"Couldn't fetch Elasticsearch fields for '{index}'",values:{index:e}}),getIndicesFetchErrorMessage:()=>s.i18n.translate("xpack.canvas.error.esService.indicesFetchErrorMessage",{defaultMessage:"Couldn't fetch Elasticsearch indices"})},RenderWithFn:{getRenderErrorMessage:e=>s.i18n.translate("xpack.canvas.error.RenderWithFn.renderErrorMessage",{defaultMessage:"Rendering '{functionName}' failed",values:{functionName:e||"function"}})},WorkpadDropzone:{getTooManyFilesErrorMessage:()=>s.i18n.translate("xpack.canvas.error.workpadDropzone.tooManyFilesErrorMessage",{defaultMessage:"One one file can be uploaded at a time"})},workpadRoutes:{getCreateFailureErrorMessage:()=>s.i18n.translate("xpack.canvas.error.workpadRoutes.createFailureErrorMessage",{defaultMessage:"Couldn't create workpad"}),getLoadFailureErrorMessage:()=>s.i18n.translate("xpack.canvas.error.workpadRoutes.loadFailureErrorMessage",{defaultMessage:"Couldn't load workpad with ID"})}},r={Color:{getDisplayName:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.colorDisplayName",{defaultMessage:"Color"}),getHelp:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.colorHelp",{defaultMessage:"Color picker"})},ContainerStyle:{getDisplayName:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyleTitle",{defaultMessage:"Container style"}),getHelp:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyleLabel",{defaultMessage:"Tweak the appearance of the element container"}),getAppearanceTitle:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.appearanceTitle",{defaultMessage:"Appearance"}),getBorderTitle:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.borderTitle",{defaultMessage:"Border"}),getPaddingLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.paddingLabel",{defaultMessage:"Padding"}),getOpacityLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.opacityLabel",{defaultMessage:"Opacity"}),getOverflowLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.overflowLabel",{defaultMessage:"Overflow"}),getOverflowHiddenOption:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.overflowHiddenDropDown",{defaultMessage:"Hidden"}),getOverflowVisibleOption:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.overflowVisibleDropDown",{defaultMessage:"Visible"}),getThicknessLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.thicknessLabel",{defaultMessage:"Thickness"}),getStyleLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.styleLabel",{defaultMessage:"Style"}),getRadiusLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.radiusLabel",{defaultMessage:"Radius"}),getColorLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.containerStyle.colorLabel",{defaultMessage:"Color"})},Font:{getDisplayName:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.fontTitle",{defaultMessage:"Text settings"}),getHelp:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.fontHelpLabel",{defaultMessage:"Set the font, size and color"})},SeriesStyle:{getDisplayName:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyleTitle",{defaultMessage:"Series style"}),getHelp:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyleLabel",{defaultMessage:"Set the style for a selected named series"}),getColorLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.colorLabel",{defaultMessage:"Color"}),getColorValueDefault:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.colorValueDefault",{defaultMessage:"Auto"}),getStyleLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.styleLabel",{defaultMessage:"Style"}),getRemoveAriaLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.removeAriaLabel",{defaultMessage:"Remove series color"}),getNoSeriesTooltip:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.noSeriesTooltip",{defaultMessage:"Data has no series to style, add a color dimension"}),getSeriesIdentifierLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.seriesIdentifierLabel",{defaultMessage:"Series id"}),getSelectSeriesOption:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.selectSeriesDropDown",{defaultMessage:"Select series"}),getLineLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.lineLabel",{defaultMessage:"Line"}),getBarLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.barLabel",{defaultMessage:"Bar"}),getPointLabel:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.pointLabel",{defaultMessage:"Point"}),getNoneOption:()=>s.i18n.translate("xpack.canvas.expressionTypes.argTypes.seriesStyle.noneDropDown",{defaultMessage:"None"})}};var o=t(159),c=t(125);const u={Palettes:{getEarthTones:()=>s.i18n.translate("xpack.canvas.lib.palettes.earthTonesLabel",{defaultMessage:"Earth Tones"}),getCanvas:()=>s.i18n.translate("xpack.canvas.lib.palettes.canvasLabel",{defaultMessage:"{CANVAS}",values:{CANVAS:n.c}}),getColorBlind:()=>s.i18n.translate("xpack.canvas.lib.palettes.colorBlindLabel",{defaultMessage:"Color Blind"}),getElasticTeal:()=>s.i18n.translate("xpack.canvas.lib.palettes.elasticTealLabel",{defaultMessage:"Elastic Teal"}),getElasticBlue:()=>s.i18n.translate("xpack.canvas.lib.palettes.elasticBlueLabel",{defaultMessage:"Elastic Blue"}),getElasticYellow:()=>s.i18n.translate("xpack.canvas.lib.palettes.elasticYellowLabel",{defaultMessage:"Elastic Yellow"}),getElasticPink:()=>s.i18n.translate("xpack.canvas.lib.palettes.elasticPinkLabel",{defaultMessage:"Elastic Pink"}),getElasticGreen:()=>s.i18n.translate("xpack.canvas.lib.palettes.elasticGreenLabel",{defaultMessage:"Elastic Green"}),getElasticOrange:()=>s.i18n.translate("xpack.canvas.lib.palettes.elasticOrangeLabel",{defaultMessage:"Elastic Orange"}),getElasticPurple:()=>s.i18n.translate("xpack.canvas.lib.palettes.elasticPurpleLabel",{defaultMessage:"Elastic Purple"}),getGreenBlueRed:()=>s.i18n.translate("xpack.canvas.lib.palettes.greenBlueRedLabel",{defaultMessage:"Green, Blue, Red"}),getYellowGreen:()=>s.i18n.translate("xpack.canvas.lib.palettes.yellowGreenLabel",{defaultMessage:"Yellow, Green"}),getYellowBlue:()=>s.i18n.translate("xpack.canvas.lib.palettes.yellowBlueLabel",{defaultMessage:"Yellow, Blue"}),getYellowRed:()=>s.i18n.translate("xpack.canvas.lib.palettes.yellowRedLabel",{defaultMessage:"Yellow, Red"}),getInstagram:()=>s.i18n.translate("xpack.canvas.lib.palettes.instagramLabel",{defaultMessage:"{INSTAGRAM}",values:{INSTAGRAM:n.o}})}},p={advancedFilter:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.advancedFilter.displayName",{defaultMessage:"Advanced filter"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.advancedFilter.helpDescription",{defaultMessage:"Render a Canvas filter expression"})},debug:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.debug.displayName",{defaultMessage:"Debug"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.debug.helpDescription",{defaultMessage:"Render debug output as formatted {JSON}",values:{JSON:n.r}})},dropdownFilter:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.dropdownFilter.displayName",{defaultMessage:"Dropdown filter"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.dropdownFilter.helpDescription",{defaultMessage:'A dropdown from which you can select values for an "{exactly}" filter',values:{exactly:"exactly"}})},embeddable:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.embeddable.displayName",{defaultMessage:"Embeddable"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.embeddable.helpDescription",{defaultMessage:"Renders an embeddable Saved Object from other parts of Kibana"})},markdown:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.markdown.displayName",{defaultMessage:"Markdown"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.markdown.helpDescription",{defaultMessage:"Render {HTML} using {MARKDOWN} input",values:{HTML:n.n,MARKDOWN:n.u}})},pie:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.pie.displayName",{defaultMessage:"Pie chart"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.pie.helpDescription",{defaultMessage:"Render a pie chart from data"})},plot:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.plot.displayName",{defaultMessage:"Coordinate plot"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.plot.helpDescription",{defaultMessage:"Render an XY plot from your data"})},table:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.table.displayName",{defaultMessage:"Data table"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.table.helpDescription",{defaultMessage:"Render tabular data as {HTML}",values:{HTML:n.n}})},text:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.text.displayName",{defaultMessage:"Plain text"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.text.helpDescription",{defaultMessage:"Render output as plain text"})},timeFilter:{getDisplayName:()=>s.i18n.translate("xpack.canvas.renderer.timeFilter.displayName",{defaultMessage:"Time filter"}),getHelpDescription:()=>s.i18n.translate("xpack.canvas.renderer.timeFilter.helpDescription",{defaultMessage:"Set a time window to filter your data"})}};t(97);const g={presentation:()=>s.i18n.translate("xpack.canvas.tags.presentationTag",{defaultMessage:"presentation"}),report:()=>s.i18n.translate("xpack.canvas.tags.reportTag",{defaultMessage:"report"})},d={fade:{getDisplayName:()=>s.i18n.translate("xpack.canvas.transitions.fade.displayName",{defaultMessage:"Fade"}),getHelp:()=>s.i18n.translate("xpack.canvas.transitions.fade.help",{defaultMessage:"Fade from one page to the next"})},rotate:{getDisplayName:()=>s.i18n.translate("xpack.canvas.transitions.rotate.displayName",{defaultMessage:"Rotate"}),getHelp:()=>s.i18n.translate("xpack.canvas.transitions.rotate.help",{defaultMessage:"Rotate from one page to the next"})},slide:{getDisplayName:()=>s.i18n.translate("xpack.canvas.transitions.slide.displayName",{defaultMessage:"Slide"}),getHelp:()=>s.i18n.translate("xpack.canvas.transitions.slide.help",{defaultMessage:"Slide from one page to the next"})},zoom:{getDisplayName:()=>s.i18n.translate("xpack.canvas.transitions.zoom.displayName",{defaultMessage:"Zoom"}),getHelp:()=>s.i18n.translate("xpack.canvas.transitions.zoom.help",{defaultMessage:"Zoom from one page to the next"})}};var f=t(129),m=t(130)},55:function(e,a,t){"use strict";t.d(a,"a",(function(){return s})),t.d(a,"b",(function(){return n})),t.d(a,"c",(function(){return l})),t.d(a,"d",(function(){return i})),t.d(a,"e",(function(){return r})),t.d(a,"f",(function(){return o})),t.d(a,"h",(function(){return c})),t.d(a,"g",(function(){return u})),t.d(a,"i",(function(){return p})),t.d(a,"j",(function(){return g})),t.d(a,"k",(function(){return d})),t.d(a,"l",(function(){return f})),t.d(a,"m",(function(){return m})),t.d(a,"n",(function(){return v})),t.d(a,"o",(function(){return x})),t.d(a,"p",(function(){return h})),t.d(a,"q",(function(){return T})),t.d(a,"r",(function(){return M})),t.d(a,"s",(function(){return k})),t.d(a,"t",(function(){return y})),t.d(a,"u",(function(){return b})),t.d(a,"v",(function(){return w})),t.d(a,"w",(function(){return S})),t.d(a,"x",(function(){return H})),t.d(a,"y",(function(){return N})),t.d(a,"z",(function(){return E})),t.d(a,"A",(function(){return L})),t.d(a,"B",(function(){return D})),t.d(a,"C",(function(){return C})),t.d(a,"D",(function(){return A})),t.d(a,"E",(function(){return F})),t.d(a,"F",(function(){return O})),t.d(a,"G",(function(){return I})),t.d(a,"H",(function(){return R})),t.d(a,"I",(function(){return B})),t.d(a,"J",(function(){return _})),t.d(a,"K",(function(){return P})),t.d(a,"L",(function(){return U}));const s="`false`",n="`true`",l="Canvas",i="_context_",r="CSS",o="CSV",c="`datemath`",u="`datatable`",p="Elasticsearch",g="ES",d="`font-family`",f="`font-weight`",m="HEX",v="HTML",x="Instagram",h="ISO8601",T="JavaScript",M="JSON",k="Lucene",y="https://www.elastic.co/guide/en/kibana/current/lucene-query.html",b="Markdown",w="MomentJS",S="https://momentjs.com/timezone/",H="Numeral pattern",N="PDF",E="RGB",L="SQL",D="https://www.elastic.co/guide/en/elasticsearch/reference/current/sql-spec.html",C="Timelion",A="https://www.elastic.co/blog/timelion-tutorial-from-zero-to-hero",F="`TinyMath`",O="https://www.elastic.co/guide/en/kibana/current/canvas-tinymath-functions.html",I="`boolean`",R="`null`",B="`number`",_="`string`",P="URL",U="ZIP"},66:function(e,a,t){"use strict";var s=t(4);t.o(s,"BackgroundRepeat")&&t.d(a,"BackgroundRepeat",(function(){return s.BackgroundRepeat})),t.o(s,"BackgroundSize")&&t.d(a,"BackgroundSize",(function(){return s.BackgroundSize})),t.o(s,"BorderStyle")&&t.d(a,"BorderStyle",(function(){return s.BorderStyle})),t.o(s,"FilterType")&&t.d(a,"FilterType",(function(){return s.FilterType})),t.o(s,"Legend")&&t.d(a,"Legend",(function(){return s.Legend})),t.o(s,"Overflow")&&t.d(a,"Overflow",(function(){return s.Overflow})),t.o(s,"Position")&&t.d(a,"Position",(function(){return s.Position})),t.o(s,"getType")&&t.d(a,"getType",(function(){return s.getType})),t.o(s,"isAxisConfig")&&t.d(a,"isAxisConfig",(function(){return s.isAxisConfig})),t.o(s,"isBorderStyle")&&t.d(a,"isBorderStyle",(function(){return s.isBorderStyle})),t(161),t(162),t(163),t(164);var n=t(165);t.d(a,"FilterType",(function(){return n.a}));var l=t(166);t.d(a,"Legend",(function(){return l.a})),t.d(a,"Position",(function(){return l.b})),t.d(a,"isAxisConfig",(function(){return l.c})),t(167),t(168),t(169),t(170);var i=t(171);t.d(a,"BorderStyle",(function(){return i.a})),t.d(a,"isBorderStyle",(function(){return i.b})),t(172)},97:function(e,a,t){"use strict";t.d(a,"a",(function(){return l}));var s=t(3),n=t(0);const l={getNamespaceDisplayNames:()=>({ELEMENT:s.i18n.translate("xpack.canvas.keyboardShortcuts.namespace.elementDisplayName",{defaultMessage:"Element controls"}),EXPRESSION:s.i18n.translate("xpack.canvas.keyboardShortcuts.namespace.expressionDisplayName",{defaultMessage:"Expression controls"}),EDITOR:s.i18n.translate("xpack.canvas.keyboardShortcuts.namespace.editorDisplayName",{defaultMessage:"Editor controls"}),PRESENTATION:s.i18n.translate("xpack.canvas.keyboardShortcuts.namespace.presentationDisplayName",{defaultMessage:"Presentation controls"})}),getShortcutHelp:()=>({CUT:s.i18n.translate("xpack.canvas.keyboardShortcuts.cutShortcutHelpText",{defaultMessage:"Cut"}),COPY:s.i18n.translate("xpack.canvas.keyboardShortcuts.copyShortcutHelpText",{defaultMessage:"Copy"}),PASTE:s.i18n.translate("xpack.canvas.keyboardShortcuts.pasteShortcutHelpText",{defaultMessage:"Paste"}),CLONE:s.i18n.translate("xpack.canvas.keyboardShortcuts.cloneShortcutHelpText",{defaultMessage:"Clone"}),DELETE:s.i18n.translate("xpack.canvas.keyboardShortcuts.deleteShortcutHelpText",{defaultMessage:"Delete"}),BRING_FORWARD:s.i18n.translate("xpack.canvas.keyboardShortcuts.bringFowardShortcutHelpText",{defaultMessage:"Bring forward"}),BRING_TO_FRONT:s.i18n.translate("xpack.canvas.keyboardShortcuts.bringToFrontShortcutHelpText",{defaultMessage:"Bring to front"}),SEND_BACKWARD:s.i18n.translate("xpack.canvas.keyboardShortcuts.sendBackwardShortcutHelpText",{defaultMessage:"Send backward"}),SEND_TO_BACK:s.i18n.translate("xpack.canvas.keyboardShortcuts.sendToBackShortcutHelpText",{defaultMessage:"Send to back"}),GROUP:s.i18n.translate("xpack.canvas.keyboardShortcuts.groupShortcutHelpText",{defaultMessage:"Group"}),UNGROUP:s.i18n.translate("xpack.canvas.keyboardShortcuts.ungroupShortcutHelpText",{defaultMessage:"Ungroup"}),SHIFT_UP:s.i18n.translate("xpack.canvas.keyboardShortcuts.shiftUpShortcutHelpText",{defaultMessage:"Shift up by {ELEMENT_SHIFT_OFFSET}px",values:{ELEMENT_SHIFT_OFFSET:n.u}}),SHIFT_DOWN:s.i18n.translate("xpack.canvas.keyboardShortcuts.shiftDownShortcutHelpText",{defaultMessage:"Shift down by {ELEMENT_SHIFT_OFFSET}px",values:{ELEMENT_SHIFT_OFFSET:n.u}}),SHIFT_LEFT:s.i18n.translate("xpack.canvas.keyboardShortcuts.shiftLeftShortcutHelpText",{defaultMessage:"Shift left by {ELEMENT_SHIFT_OFFSET}px",values:{ELEMENT_SHIFT_OFFSET:n.u}}),SHIFT_RIGHT:s.i18n.translate("xpack.canvas.keyboardShortcuts.shiftRightShortcutHelpText",{defaultMessage:"Shift right by {ELEMENT_SHIFT_OFFSET}px",values:{ELEMENT_SHIFT_OFFSET:n.u}}),NUDGE_UP:s.i18n.translate("xpack.canvas.keyboardShortcuts.nudgeUpShortcutHelpText",{defaultMessage:"Shift up by {ELEMENT_NUDGE_OFFSET}px",values:{ELEMENT_NUDGE_OFFSET:n.t}}),NUDGE_DOWN:s.i18n.translate("xpack.canvas.keyboardShortcuts.nudgeDownShortcutHelpText",{defaultMessage:"Shift down by {ELEMENT_NUDGE_OFFSET}px",values:{ELEMENT_NUDGE_OFFSET:n.t}}),NUDGE_LEFT:s.i18n.translate("xpack.canvas.keyboardShortcuts.nudgeLeftShortcutHelpText",{defaultMessage:"Shift left by {ELEMENT_NUDGE_OFFSET}px",values:{ELEMENT_NUDGE_OFFSET:n.t}}),NUDGE_RIGHT:s.i18n.translate("xpack.canvas.keyboardShortcuts.nudgeRightShortcutHelpText",{defaultMessage:"Shift right by {ELEMENT_NUDGE_OFFSET}px",values:{ELEMENT_NUDGE_OFFSET:n.t}}),RUN:s.i18n.translate("xpack.canvas.keyboardShortcuts.runShortcutHelpText",{defaultMessage:"Run whole expression"}),MULTISELECT:s.i18n.translate("xpack.canvas.keyboardShortcuts.multiselectShortcutHelpText",{defaultMessage:"Select multiple elements"}),RESIZE_FROM_CENTER:s.i18n.translate("xpack.canvas.keyboardShortcuts.resizeFromCenterShortcutHelpText",{defaultMessage:"Resize from center"}),IGNORE_SNAP:s.i18n.translate("xpack.canvas.keyboardShortcuts.ignoreSnapShortcutHelpText",{defaultMessage:"Move, resize, and rotate without snapping"}),SELECT_BEHIND:s.i18n.translate("xpack.canvas.keyboardShortcuts.selectBehindShortcutHelpText",{defaultMessage:"Select element below"}),UNDO:s.i18n.translate("xpack.canvas.keyboardShortcuts.undoShortcutHelpText",{defaultMessage:"Undo last action"}),REDO:s.i18n.translate("xpack.canvas.keyboardShortcuts.redoShortcutHelpText",{defaultMessage:"Redo last action"}),PREV:s.i18n.translate("xpack.canvas.keyboardShortcuts.prevShortcutHelpText",{defaultMessage:"Go to previous page"}),NEXT:s.i18n.translate("xpack.canvas.keyboardShortcuts.nextShortcutHelpText",{defaultMessage:"Go to next page"}),EDITING:s.i18n.translate("xpack.canvas.keyboardShortcuts.editingShortcutHelpText",{defaultMessage:"Toggle edit mode"}),GRID:s.i18n.translate("xpack.canvas.keyboardShortcuts.gridShortcutHelpText",{defaultMessage:"Show grid"}),REFRESH:s.i18n.translate("xpack.canvas.keyboardShortcuts.ShortcutHelpText",{defaultMessage:"Refresh workpad"}),ZOOM_IN:s.i18n.translate("xpack.canvas.keyboardShortcuts.zoomInShortcutHelpText",{defaultMessage:"Zoom in"}),ZOOM_OUT:s.i18n.translate("xpack.canvas.keyboardShortcuts.zoomOutShortcutHelpText",{defaultMessage:"Zoom out"}),ZOOM_RESET:s.i18n.translate("xpack.canvas.keyboardShortcuts.zoomResetShortcutHelpText",{defaultMessage:"Reset zoom to 100%"}),FULLSCREEN:s.i18n.translate("xpack.canvas.keyboardShortcuts.fullscreenShortcutHelpText",{defaultMessage:"Enter presentation mode"}),FULLSCREEN_EXIT:s.i18n.translate("xpack.canvas.keyboardShortcuts.fullscreenExitShortcutHelpText",{defaultMessage:"Exit presentation mode"}),PAGE_CYCLE_TOGGLE:s.i18n.translate("xpack.canvas.keyboardShortcuts.pageCycleToggleShortcutHelpText",{defaultMessage:"Toggle page cycling"})})}}}]);