"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventType = getEventType;

var _latency_distribution_chart_types = require("../../../../common/latency_distribution_chart_types");

var _processor_event = require("../../../../common/processor_event");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  transactionLatency,
  latencyCorrelations,
  failedTransactionsCorrelations,
  dependencyLatency
} = _latency_distribution_chart_types.LatencyDistributionChartType;

function getEventType(chartType, searchMetrics) {
  switch (chartType) {
    case transactionLatency:
      if (searchMetrics) {
        return _processor_event.ProcessorEvent.metric;
      }

      return _processor_event.ProcessorEvent.transaction;

    case latencyCorrelations:
      return _processor_event.ProcessorEvent.transaction;

    case failedTransactionsCorrelations:
      return _processor_event.ProcessorEvent.transaction;

    case dependencyLatency:
      return _processor_event.ProcessorEvent.span;

    default:
      return _processor_event.ProcessorEvent.transaction;
  }
}