"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchKeywordFieldStats = void 0;

var _get_common_correlations_query = require("../get_common_correlations_query");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fetchKeywordFieldStats = async ({
  setup,
  eventType,
  start,
  end,
  environment,
  kuery,
  query,
  field
}) => {
  var _aggregations$sampled, _aggregations$sampled2, _aggregations$sampled3, _aggregations$sampled4;

  const {
    apmEventClient
  } = setup;
  const body = await apmEventClient.search('get_keyword_field_stats', {
    apm: {
      events: [eventType]
    },
    body: {
      size: 0,
      track_total_hits: false,
      query: (0, _get_common_correlations_query.getCommonCorrelationsQuery)({
        start,
        end,
        kuery,
        environment,
        query
      }),
      aggs: {
        sampled_top: {
          terms: {
            field: field.fieldName,
            size: 10
          }
        }
      }
    }
  });
  const aggregations = body.aggregations;
  const topValues = (_aggregations$sampled = aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$sampled2 = aggregations.sampled_top) === null || _aggregations$sampled2 === void 0 ? void 0 : _aggregations$sampled2.buckets) !== null && _aggregations$sampled !== void 0 ? _aggregations$sampled : [];
  const stats = {
    fieldName: field.fieldName,
    topValues,
    topValuesSampleSize: topValues.reduce((acc, curr) => acc + curr.doc_count, (_aggregations$sampled3 = aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$sampled4 = aggregations.sampled_top) === null || _aggregations$sampled4 === void 0 ? void 0 : _aggregations$sampled4.sum_other_doc_count) !== null && _aggregations$sampled3 !== void 0 ? _aggregations$sampled3 : 0)
  };
  return stats;
};

exports.fetchKeywordFieldStats = fetchKeywordFieldStats;