"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortByTime = exports.isRangeAnnotation = exports.isManualPointAnnotation = exports.filterOutOfTimeRange = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const isRangeAnnotation = annotation => {
  return 'endTime' in annotation;
};

exports.isRangeAnnotation = isRangeAnnotation;

const isManualPointAnnotation = annotation => {
  return 'time' in annotation && !('endTime' in annotation);
};

exports.isManualPointAnnotation = isManualPointAnnotation;

const filterOutOfTimeRange = (annotation, timerange) => {
  if (!timerange) {
    return false;
  }

  if (isRangeAnnotation(annotation)) {
    return !(annotation.time >= timerange.to || annotation.endTime < timerange.from);
  }

  if (isManualPointAnnotation(annotation)) {
    return annotation.time >= timerange.from && annotation.time <= timerange.to;
  }
};

exports.filterOutOfTimeRange = filterOutOfTimeRange;

const sortByTime = (a, b) => {
  return a.time.localeCompare(b.time);
};

exports.sortByTime = sortByTime;