"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEventAnnotations = fetchEventAnnotations;

var _rxjs = require("rxjs");

var _i18n = require("@kbn/i18n");

var _common = require("../../../data/common");

var _moment = _interopRequireDefault(require("moment"));

var _charts = require("@elastic/charts");

var _types = require("../manual_event_annotation/types");

var _utils = require("./utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function fetchEventAnnotations() {
  return {
    name: 'fetch_event_annotations',
    aliases: [],
    type: 'datatable',
    inputTypes: ['kibana_context', 'null'],
    help: _i18n.i18n.translate('eventAnnotation.fetchEventAnnotations.description', {
      defaultMessage: 'Fetch event annotations'
    }),
    args: {
      group: {
        types: ['event_annotation_group'],
        help: _i18n.i18n.translate('eventAnnotation.fetchEventAnnotations.args.annotationConfigs', {
          defaultMessage: 'Annotation configs'
        }),
        multi: true
      },
      interval: {
        required: true,
        types: ['string'],
        help: _i18n.i18n.translate('eventAnnotation.fetchEventAnnotations.args.interval.help', {
          defaultMessage: 'Interval to use for this aggregation'
        })
      }
    },
    fn: (input, args) => {
      return (0, _rxjs.defer)(async () => {
        const annotations = args.group.flatMap(group => group.annotations).filter(annotation => !annotation.isHidden && (0, _utils.filterOutOfTimeRange)(annotation, input === null || input === void 0 ? void 0 : input.timeRange)); // TODO: fetching for Query annotations goes here

        return {
          annotations
        };
      }).pipe((0, _rxjs.switchMap)(({
        annotations
      }) => {
        const datatable = {
          type: 'datatable',
          columns: _types.annotationColumns,
          rows: annotations.sort(_utils.sortByTime).map(annotation => {
            const initialDate = (0, _moment.default)(annotation.time).valueOf();
            const snappedDate = (0, _charts.roundDateToESInterval)(initialDate, (0, _common.parseEsInterval)(args.interval), 'start', 'UTC');
            return { ...annotation,
              type: (0, _utils.isManualPointAnnotation)(annotation) ? 'point' : 'range',
              timebucket: (0, _moment.default)(snappedDate).toISOString()
            };
          })
        };
        return new _rxjs.Observable(subscriber => {
          subscriber.next(datatable);
          subscriber.complete();
        });
      }));
    }
  };
}