"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupServer = exports.createExportableType = void 0;

var _coreExecutionContextServerMocks = require("@kbn/core-execution-context-server-mocks");

var _coreHttpContextServerInternal = require("@kbn/core-http-context-server-internal");

var _coreHttpServerMocks = require("@kbn/core-http-server-mocks");

var _mocks = require("../../mocks");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const defaultCoreId = Symbol('core');

const setupServer = async (coreId = defaultCoreId) => {
  const coreContext = (0, _coreHttpServerMocks.createCoreContext)({
    coreId
  });
  const contextService = new _coreHttpContextServerInternal.ContextService(coreContext);
  const server = (0, _coreHttpServerMocks.createHttpServer)(coreContext);
  await server.preboot({
    context: _mocks.contextServiceMock.createPrebootContract()
  });
  const httpSetup = await server.setup({
    context: contextService.setup({
      pluginDependencies: new Map()
    }),
    executionContext: _coreExecutionContextServerMocks.executionContextServiceMock.createInternalSetupContract()
  });

  const handlerContext = _mocks.coreMock.createRequestHandlerContext();

  httpSetup.registerRouteHandlerContext(coreId, 'core', (ctx, req, res) => {
    return handlerContext;
  });
  return {
    server,
    httpSetup,
    handlerContext
  };
};

exports.setupServer = setupServer;

const createExportableType = name => {
  return {
    name,
    hidden: false,
    namespaceType: 'single',
    mappings: {
      properties: {}
    },
    management: {
      importableAndExportable: true
    }
  };
};

exports.createExportableType = createExportableType;