"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nonEmptyEntriesArray = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _entries = require("../entries");

var _entries_list = require("../entries_list");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Types the nonEmptyEntriesArray as:
 *   - An array of entries of length 1 or greater
 *
 */
const nonEmptyEntriesArray = new t.Type('NonEmptyEntriesArray', _entries.entriesArray.is, (input, context) => {
  if (Array.isArray(input) && input.length === 0) {
    return t.failure(input, context);
  } else {
    if (Array.isArray(input) && input.some(entry => _entries_list.entriesList.is(entry)) && input.some(entry => !_entries_list.entriesList.is(entry))) {
      // fail when an exception item contains both a value list entry and a non-value list entry
      return t.failure(input, context, 'Cannot have entry of type list and other');
    }

    return _entries.entriesArray.validate(input, context);
  }
}, t.identity);
exports.nonEmptyEntriesArray = nonEmptyEntriesArray;