"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionsCamel = exports.actions = exports.action_params = exports.action_id = exports.action_group = exports.action_action_type_id = exports.action = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _saved_object_attributes = require("../saved_object_attributes");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable @typescript-eslint/naming-convention */

/**
 * Params is an "object", since it is a type of RuleActionParams which is action templates.
 * @see x-pack/plugins/alerting/common/rule.ts
 */
const action_group = t.string;
exports.action_group = action_group;
const action_id = t.string;
exports.action_id = action_id;
const action_action_type_id = t.string;
exports.action_action_type_id = action_action_type_id;
const action_params = _saved_object_attributes.saved_object_attributes;
exports.action_params = action_params;
const action = t.exact(t.type({
  group: action_group,
  id: action_id,
  action_type_id: action_action_type_id,
  params: action_params
}));
exports.action = action;
const actions = t.array(action);
exports.actions = actions;
const actionsCamel = t.array(t.exact(t.type({
  group: action_group,
  id: action_id,
  actionTypeId: action_action_type_id,
  params: action_params
})));
exports.actionsCamel = actionsCamel;