import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { merge as lodashMerge } from 'lodash';
import { isLeft } from 'fp-ts/lib/Either';
export function mergeRt() {
  for (var _len = arguments.length, types = new Array(_len), _key = 0; _key < _len; _key++) {
    types[_key] = arguments[_key];
  }

  var mergeType = new t.Type('merge', function (u) {
    return types.every(function (type) {
      return type.is(u);
    });
  }, function (input, context) {
    var errors = [];
    var successes = [];
    var results = types.map(function (type, index) {
      return type.validate(input, context.concat({
        key: String(index),
        type: type,
        actual: input
      }));
    });
    results.forEach(function (result) {
      if (isLeft(result)) {
        errors.push.apply(errors, _toConsumableArray(result.left));
      } else {
        successes.push(result.right);
      }
    });
    var mergedValues = lodashMerge.apply(void 0, [{}].concat(successes));
    return errors.length > 0 ? t.failures(errors) : t.success(mergedValues);
  }, function (a) {
    return types.reduce(function (val, type) {
      return type.encode(val);
    }, a);
  });
  return _objectSpread(_objectSpread({}, mergeType), {}, {
    _tag: 'MergeType',
    types: types
  });
}