/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { either } from 'fp-ts/lib/Either';
export var jsonRt = new t.Type('JSON', t.any.is, function (input, context) {
  return either.chain(t.string.validate(input, context), function (str) {
    try {
      return t.success(JSON.parse(str));
    } catch (e) {
      return t.failure(input, context);
    }
  });
}, function (a) {
  return JSON.stringify(a);
});