import _typeof from "@babel/runtime/helpers/typeof";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { clone } from 'lodash';
export var Registry = /*#__PURE__*/function () {
  // eslint-disable-next-line @typescript-eslint/ban-types
  function Registry() {
    var prop = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'name';

    _classCallCheck(this, Registry);

    _defineProperty(this, "_prop", void 0);

    _defineProperty(this, "_indexed", void 0);

    if (typeof prop !== 'string') throw new Error('Registry property name must be a string');
    this._prop = prop;
    this._indexed = new Object();
  }

  _createClass(Registry, [{
    key: "wrapper",
    value: function wrapper(obj) {
      // @ts-ignore
      return obj;
    }
  }, {
    key: "register",
    value: function register(fn) {
      var obj = typeof fn === 'function' ? fn() : fn; // @ts-ignore

      if (_typeof(obj) !== 'object' || !obj[this._prop]) {
        throw new Error("Registered functions must return an object with a ".concat(this._prop, " property"));
      } // @ts-ignore


      this._indexed[obj[this._prop].toLowerCase()] = this.wrapper(obj);
    }
  }, {
    key: "toJS",
    value: function toJS() {
      var _this = this;

      return Object.keys(this._indexed).reduce(function (acc, key) {
        // @ts-ignore
        acc[key] = _this.get(key);
        return acc;
      }, {});
    }
  }, {
    key: "toArray",
    value: function toArray() {
      var _this2 = this;

      return Object.keys(this._indexed).map(function (key) {
        return _this2.get(key);
      });
    }
  }, {
    key: "get",
    value: function get(name) {
      // @ts-ignore
      if (name === undefined) return null;
      var lowerCaseName = name.toLowerCase(); // @ts-ignore

      return this._indexed[lowerCaseName] ? clone(this._indexed[lowerCaseName]) : null;
    }
  }, {
    key: "getProp",
    value: function getProp() {
      return this._prop;
    }
  }, {
    key: "reset",
    value: function reset() {
      this._indexed = new Object();
    }
  }]);

  return Registry;
}();