import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { keys, partition } from 'lodash';
import { isRangeFilter } from '../build_filters';
import { convertRangeFilterToTimeRangeString } from './convert_range_filter';
export function extractTimeFilter(timeFieldName, filters) {
  var _partition = partition(filters, function (obj) {
    var key;

    if (isRangeFilter(obj)) {
      key = keys(obj.query.range)[0];
    }

    return Boolean(key && key === timeFieldName);
  }),
      _partition2 = _slicedToArray(_partition, 2),
      timeRangeFilter = _partition2[0],
      restOfFilters = _partition2[1];

  return {
    restOfFilters: restOfFilters,
    timeRangeFilter: timeRangeFilter[0]
  };
}
export function extractTimeRange(filters, timeFieldName) {
  if (!timeFieldName) return {
    restOfFilters: filters,
    timeRange: undefined
  };

  var _extractTimeFilter = extractTimeFilter(timeFieldName, filters),
      timeRangeFilter = _extractTimeFilter.timeRangeFilter,
      restOfFilters = _extractTimeFilter.restOfFilters;

  return {
    restOfFilters: restOfFilters,
    timeRange: timeRangeFilter ? convertRangeFilterToTimeRangeString(timeRangeFilter) : undefined
  };
}