/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { decorateQuery } from './decorate_query';
import { luceneStringToDsl } from './lucene_string_to_dsl';

/** @internal */
export function buildQueryFromLucene(queries) {
  var queryStringOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var dateFormatTZ = arguments.length > 2 ? arguments[2] : undefined;
  var combinedQueries = (queries || []).map(function (query) {
    var queryDsl = luceneStringToDsl(query.query);
    return decorateQuery(queryDsl, queryStringOptions, dateFormatTZ);
  });
  return {
    must: combinedQueries,
    filter: [],
    should: [],
    must_not: []
  };
}