"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Env = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _path = require("path");

var _loadJsonFile = _interopRequireDefault(require("load-json-file"));

var _pluginDiscovery = require("@kbn/plugin-discovery");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class Env {
  /**
   * @internal
   */
  static createDefault(repoRoot, options, pkg) {
    if (!pkg) {
      pkg = _loadJsonFile.default.sync((0, _path.join)(repoRoot, 'package.json'));
    }

    return new Env(repoRoot, pkg, options);
  }
  /** @internal */


  /**
   * @internal
   */
  constructor(homeDir, pkg, options) {
    (0, _defineProperty2.default)(this, "configDir", void 0);
    (0, _defineProperty2.default)(this, "binDir", void 0);
    (0, _defineProperty2.default)(this, "logDir", void 0);
    (0, _defineProperty2.default)(this, "pluginSearchPaths", void 0);
    (0, _defineProperty2.default)(this, "packageInfo", void 0);
    (0, _defineProperty2.default)(this, "mode", void 0);
    (0, _defineProperty2.default)(this, "cliArgs", void 0);
    (0, _defineProperty2.default)(this, "configs", void 0);
    this.homeDir = homeDir;
    this.configDir = (0, _path.resolve)(this.homeDir, 'config');
    this.binDir = (0, _path.resolve)(this.homeDir, 'bin');
    this.logDir = (0, _path.resolve)(this.homeDir, 'log');
    this.pluginSearchPaths = (0, _pluginDiscovery.getPluginSearchPaths)({
      rootDir: this.homeDir,
      oss: options.cliArgs.oss,
      examples: options.cliArgs.runExamples
    });
    this.cliArgs = Object.freeze(options.cliArgs);
    this.configs = Object.freeze(options.configs);
    const isDevMode = this.cliArgs.dev || this.cliArgs.envName === 'development';
    this.mode = Object.freeze({
      dev: isDevMode,
      name: isDevMode ? 'development' : 'production',
      prod: !isDevMode
    });
    const isKibanaDistributable = Boolean(pkg.build && pkg.build.distributable === true);
    this.packageInfo = Object.freeze({
      branch: pkg.branch,
      buildNum: isKibanaDistributable ? pkg.build.number : Number.MAX_SAFE_INTEGER,
      buildSha: isKibanaDistributable ? pkg.build.sha : 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
      version: pkg.version,
      dist: isKibanaDistributable
    });
  }

}

exports.Env = Env;