"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configServiceMock = void 0;

var _rxjs = require("rxjs");

var _config = require("@kbn/config");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const createConfigServiceMock = ({
  atPath = {},
  getConfig$ = {}
} = {}) => {
  const mocked = {
    atPath: jest.fn(),
    atPathSync: jest.fn(),
    getConfig$: jest.fn(),
    getUsedPaths: jest.fn(),
    getUnusedPaths: jest.fn(),
    isEnabledAtPath: jest.fn(),
    setSchema: jest.fn(),
    addDeprecationProvider: jest.fn(),
    validate: jest.fn(),
    getHandledDeprecatedConfigs: jest.fn(),
    getDeprecatedConfigPath$: jest.fn()
  };
  mocked.atPath.mockReturnValue(new _rxjs.BehaviorSubject(atPath));
  mocked.atPathSync.mockReturnValue(atPath);
  mocked.getConfig$.mockReturnValue(new _rxjs.BehaviorSubject(new _config.ObjectToConfigAdapter(getConfig$)));
  mocked.getDeprecatedConfigPath$.mockReturnValue(new _rxjs.BehaviorSubject({
    set: [],
    unset: []
  }));
  mocked.getUsedPaths.mockResolvedValue([]);
  mocked.getUnusedPaths.mockResolvedValue([]);
  mocked.isEnabledAtPath.mockResolvedValue(true);
  mocked.getHandledDeprecatedConfigs.mockReturnValue([]);
  return mocked;
};

const configServiceMock = {
  create: createConfigServiceMock
};
exports.configServiceMock = configServiceMock;