import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { checkIsMaxContinuity, checkIsMinContinuity, roundValue, getDataMinMax } from '../../../../palettes';

/**
 * Check if item is last
 * @internal
 */
export var isLastItem = function isLastItem(accessor) {
  return accessor === 'end';
};
/**
 * Sort Color ranges array
 * @internal
 */

export var sortColorRanges = function sortColorRanges(colorRanges) {
  var lastRange = colorRanges[colorRanges.length - 1]; // we should add last end as new start because we should include it on sorting

  return [].concat(_toConsumableArray(colorRanges), [{
    start: lastRange.end,
    color: lastRange.color,
    end: undefined
  }]).sort(function (_ref, _ref2) {
    var startA = _ref.start;
    var startB = _ref2.start;
    return Number(startA) - Number(startB);
  }).reduce(function (sortedColorRange, newColorRange, i, array) {
    // we should pick correct color for the last range.
    // If after sorting we don't change last value we should just take color in array order
    // In another case we should get the next one.
    var color = newColorRange.color;

    if (i === array.length - 2 && array[i + 1].start !== lastRange.end) {
      color = array[i + 1].color;
    }

    if (i !== array.length - 1) {
      sortedColorRange.push({
        color: color,
        start: newColorRange.start,
        end: array[i + 1].start
      });
    }

    return sortedColorRange;
  }, []);
};
/**
 * Calculate max step
 * @internal
 */

export var calculateMaxStep = function calculateMaxStep(stops, max) {
  var step = 1;

  if (stops.length > 1) {
    var last = stops[stops.length - 1];
    var last2step = stops[stops.length - 1] - stops[stops.length - 2];

    if (last + last2step < max) {
      step = last2step;
    }
  }

  return roundValue(step);
};
/**
 * Convert ColorRange to ColorStops
 * @internal
 */

export var toColorStops = function toColorStops(colorRanges, continuity) {
  var min = checkIsMinContinuity(continuity) ? Number.NEGATIVE_INFINITY : colorRanges[0].start;
  var max = checkIsMaxContinuity(continuity) ? Number.POSITIVE_INFINITY : colorRanges[colorRanges.length - 1].end;
  return {
    min: min,
    max: max,
    colorStops: colorRanges.map(function (colorRange, i) {
      return {
        color: colorRange.color,
        stop: i === 0 ? min : colorRange.start
      };
    })
  };
};
/**
 * Calculate right max or min value for new continuity
 */

export var getValueForContinuity = function getValueForContinuity(colorRanges, continuity, isLast, rangeType, dataBounds) {
  var _getDataMinMax = getDataMinMax(rangeType, dataBounds),
      max = _getDataMinMax.max,
      min = _getDataMinMax.min;

  var value;

  if (isLast) {
    if (checkIsMaxContinuity(continuity)) {
      value = Number.POSITIVE_INFINITY;
    } else {
      value = roundValue(colorRanges[colorRanges.length - 1].start > max ? colorRanges[colorRanges.length - 1].start + 1 : max);
    }
  } else {
    if (checkIsMinContinuity(continuity)) {
      value = Number.NEGATIVE_INFINITY;
    } else {
      value = roundValue(colorRanges[0].end < min ? colorRanges[0].end - 1 : min);
    }
  }

  return value;
};