import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { i18n } from '@kbn/i18n';
import { isValidColor } from '../utils';

/** @internal **/
export var getErrorMessages = function getErrorMessages(colorRangesValidity) {
  return Array.from(new Set(Object.values(colorRangesValidity).map(function (item) {
    return item.errors;
  }).flat().map(function (item) {
    switch (item) {
      case 'invalidColor':
      case 'invalidValue':
        return i18n.translate('coloring.dynamicColoring.customPalette.invalidValueOrColor', {
          defaultMessage: 'At least one color range contains the wrong value or color'
        });

      case 'greaterThanMaxValue':
        return i18n.translate('coloring.dynamicColoring.customPalette.invalidMaxValue', {
          defaultMessage: 'Maximum value must be greater than preceding values'
        });

      default:
        return '';
    }
  })));
};
/** @internal **/

export var validateColorRange = function validateColorRange(colorRange, accessor) {
  var errors = [];

  if (Number.isNaN(colorRange[accessor])) {
    errors.push('invalidValue');
  }

  if (accessor === 'end') {
    if (colorRange.start > colorRange.end) {
      errors.push('greaterThanMaxValue');
    }
  } else if (!isValidColor(colorRange.color)) {
    errors.push('invalidColor');
  }

  return {
    isValid: !errors.length,
    errors: errors
  };
};
export var validateColorRanges = function validateColorRanges(colorRanges) {
  var validations = colorRanges.reduce(function (acc, item, index) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, index, validateColorRange(item, 'start')));
  }, {});
  return _objectSpread(_objectSpread({}, validations), {}, {
    last: validateColorRange(colorRanges[colorRanges.length - 1], 'end')
  });
};
export var isAllColorRangesValid = function isAllColorRangesValid(colorRanges) {
  return Object.values(validateColorRanges(colorRanges)).every(function (colorRange) {
    return colorRange.isValid;
  });
};