import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { i18n } from '@kbn/i18n';
import useUpdateEffect from 'react-use/lib/useUpdateEffect';
import React, { useState, useCallback, useContext } from 'react';
import { EuiFieldNumber, EuiColorPicker, EuiFlexItem, EuiFlexGroup, EuiIcon, EuiColorPickerSwatch, EuiButtonIcon } from '@elastic/eui';
import { checkIsMaxContinuity, checkIsMinContinuity } from '../../../palettes';
import { RelatedIcon } from '../assets/related';
import { isLastItem } from './utils';
import { isValidColor } from '../utils';
import { ColorRangeDeleteButton, ColorRangeAutoDetectButton, ColorRangeEditButton } from './color_ranges_item_buttons';
import { ColorRangesContext } from './color_ranges_context';
import { jsx as ___EmotionJSX } from "@emotion/react";

var getMode = function getMode(index, isLast, continuity) {
  if (!isLast && index > 0) {
    return 'value';
  }

  return (isLast ? checkIsMaxContinuity : checkIsMinContinuity)(continuity) ? 'auto' : 'edit';
};

var getPlaceholderForAutoMode = function getPlaceholderForAutoMode(isLast) {
  return isLast ? i18n.translate('coloring.dynamicColoring.customPalette.maxValuePlaceholder', {
    defaultMessage: 'Max. value'
  }) : i18n.translate('coloring.dynamicColoring.customPalette.minValuePlaceholder', {
    defaultMessage: 'Min. value'
  });
};

var getActionButton = function getActionButton(mode) {
  if (mode === 'value') {
    return ColorRangeDeleteButton;
  }

  return mode === 'edit' ? ColorRangeAutoDetectButton : ColorRangeEditButton;
};

var getAppend = function getAppend(rangeType, mode) {
  var items = [];

  if (rangeType === 'percent' && mode !== 'auto') {
    items.push('%');
  }

  return items;
};

export function ColorRangeItem(_ref) {
  var _validation$isValid;

  var accessor = _ref.accessor,
      index = _ref.index,
      colorRange = _ref.colorRange,
      rangeType = _ref.rangeType,
      colorRanges = _ref.colorRanges,
      validation = _ref.validation,
      continuity = _ref.continuity,
      dispatch = _ref.dispatch;

  var _useContext = useContext(ColorRangesContext),
      dataBounds = _useContext.dataBounds,
      palettes = _useContext.palettes;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      popoverInFocus = _useState2[0],
      setPopoverInFocus = _useState2[1];

  var _useState3 = useState(colorRange[accessor]),
      _useState4 = _slicedToArray(_useState3, 2),
      localValue = _useState4[0],
      setLocalValue = _useState4[1];

  var isLast = isLastItem(accessor);
  var mode = getMode(index, isLast, continuity);
  var isDisabled = mode === 'auto';
  var isColorValid = isValidColor(colorRange.color);
  var ActionButton = getActionButton(mode);
  var isValid = (_validation$isValid = validation === null || validation === void 0 ? void 0 : validation.isValid) !== null && _validation$isValid !== void 0 ? _validation$isValid : true;
  var onLeaveFocus = useCallback(function (e) {
    var _colorRanges$start, _colorRanges, _colorRanges$start2, _colorRanges2, _colorRanges$end, _colorRanges3, _e$currentTarget;

    var prevStartValue = (_colorRanges$start = (_colorRanges = colorRanges[index - 1]) === null || _colorRanges === void 0 ? void 0 : _colorRanges.start) !== null && _colorRanges$start !== void 0 ? _colorRanges$start : Number.NEGATIVE_INFINITY;
    var nextStartValue = (_colorRanges$start2 = (_colorRanges2 = colorRanges[index + 1]) === null || _colorRanges2 === void 0 ? void 0 : _colorRanges2.start) !== null && _colorRanges$start2 !== void 0 ? _colorRanges$start2 : Number.POSITIVE_INFINITY;
    var lastEndValue = (_colorRanges$end = (_colorRanges3 = colorRanges[colorRanges.length - 1]) === null || _colorRanges3 === void 0 ? void 0 : _colorRanges3.end) !== null && _colorRanges$end !== void 0 ? _colorRanges$end : Number.POSITIVE_INFINITY;
    var shouldSort = colorRange.start > nextStartValue || prevStartValue > colorRange.start || !isLast && colorRange.start > lastEndValue;
    var isFocusStillInContent = ((_e$currentTarget = e.currentTarget) === null || _e$currentTarget === void 0 ? void 0 : _e$currentTarget.contains(e.relatedTarget)) || popoverInFocus;

    if (shouldSort && !isFocusStillInContent) {
      dispatch({
        type: 'sortColorRanges',
        payload: {
          dataBounds: dataBounds,
          palettes: palettes
        }
      });
    }
  }, [colorRange.start, colorRanges, dispatch, index, popoverInFocus, dataBounds, palettes, isLast]);
  var onValueChange = useCallback(function (_ref2) {
    var targetValue = _ref2.target.value;
    setLocalValue(targetValue);
    dispatch({
      type: 'updateValue',
      payload: {
        index: index,
        value: targetValue,
        accessor: accessor,
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [dispatch, index, accessor, dataBounds, palettes]);
  var onUpdateColor = useCallback(function (color) {
    dispatch({
      type: 'updateColor',
      payload: {
        index: index,
        color: color,
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [dispatch, index, dataBounds, palettes]);
  useUpdateEffect(function () {
    if (!Number.isNaN(colorRange[accessor]) && colorRange[accessor] !== localValue) {
      setLocalValue(colorRange[accessor]);
    }
  }, [localValue, colorRange, accessor]);
  var selectNewColorText = i18n.translate('coloring.dynamicColoring.customPalette.selectNewColor', {
    defaultMessage: 'Select a new color'
  });
  return ___EmotionJSX(EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, !isLast ? ___EmotionJSX(EuiColorPicker, {
    onChange: onUpdateColor,
    button: isColorValid ? ___EmotionJSX(EuiColorPickerSwatch, {
      color: colorRange.color,
      "aria-label": selectNewColorText
    }) : ___EmotionJSX(EuiButtonIcon, {
      color: "danger",
      iconType: "stopSlash",
      iconSize: "l",
      "aria-label": selectNewColorText
    }),
    secondaryInputDisplay: "top",
    color: colorRange.color,
    showAlpha: true,
    onFocus: function onFocus() {
      return setPopoverInFocus(true);
    },
    onBlur: function onBlur() {
      setPopoverInFocus(false);
    },
    isInvalid: !isColorValid
  }) : ___EmotionJSX(EuiIcon, {
    type: RelatedIcon,
    size: "l"
  })), ___EmotionJSX(EuiFlexItem, {
    grow: true
  }, ___EmotionJSX(EuiFieldNumber, {
    compressed: true,
    fullWidth: true,
    isInvalid: !isValid,
    value: mode !== 'auto' && localValue !== undefined && isFinite(localValue) ? localValue : '',
    disabled: isDisabled,
    onChange: onValueChange,
    placeholder: mode === 'auto' ? getPlaceholderForAutoMode(isLast) : '',
    append: getAppend(rangeType, mode),
    onBlur: onLeaveFocus,
    "data-test-subj": "lnsPalettePanel_dynamicColoring_range_value_".concat(index),
    prepend: ___EmotionJSX("span", {
      className: "euiFormLabel"
    }, isLast ? "\u2264" : "\u2265"),
    "aria-label": i18n.translate('coloring.dynamicColoring.customPalette.rangeAriaLabel', {
      defaultMessage: 'Range {index}',
      values: {
        index: index + 1
      }
    }),
    step: "any"
  })), ActionButton ? ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(ActionButton, {
    index: index,
    continuity: continuity,
    rangeType: rangeType,
    colorRanges: colorRanges,
    dispatch: dispatch,
    accessor: accessor
  })) : null);
}