import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _createSuper from "@babel/runtime/helpers/createSuper";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
import { Stream } from 'stream';
import * as zlib from 'zlib';
import { acceptCompression } from './accept_compression';
/**
 * TODO: Replace these with kbn packaged versions once we have those available to us.
 * At the moment imports from runtime plugins into packages are not supported.
 * import type { Headers } from '@kbn/core/server';
 */

// We need this otherwise Kibana server will crash with a 'ERR_METHOD_NOT_IMPLEMENTED' error.
var ResponseStream = /*#__PURE__*/function (_Stream$PassThrough) {
  _inherits(ResponseStream, _Stream$PassThrough);

  var _super = _createSuper(ResponseStream);

  function ResponseStream() {
    _classCallCheck(this, ResponseStream);

    return _super.apply(this, arguments);
  }

  _createClass(ResponseStream, [{
    key: "flush",
    value: function flush() {}
  }, {
    key: "_read",
    value: function _read() {}
  }]);

  return ResponseStream;
}(Stream.PassThrough);

var DELIMITER = '\n';

/**
 * Sets up a response stream with support for gzip compression depending on provided
 * request headers. Any non-string data pushed to the stream will be stream as NDJSON.
 *
 * @param headers - Request headers.
 * @returns An object with stream attributes and methods.
 */
export function streamFactory(headers, logger) {
  var streamType;
  var isCompressed = acceptCompression(headers);
  var stream = isCompressed ? zlib.createGzip() : new ResponseStream();

  function end() {
    stream.end();
  }

  function push(d) {
    if (d === undefined) {
      logger.error('Stream chunk must not be undefined.');
      return;
    } // Initialize the stream type with the first push to the stream,
    // otherwise check the integrity of the data to be pushed.


    if (streamType === undefined) {
      streamType = typeof d === 'string' ? 'string' : 'ndjson';
    } else if (streamType === 'string' && typeof d !== 'string') {
      logger.error('Must not push non-string chunks to a string based stream.');
      return;
    } else if (streamType === 'ndjson' && typeof d === 'string') {
      logger.error('Must not push raw string chunks to an NDJSON based stream.');
      return;
    }

    try {
      var line = typeof d !== 'string' ? "".concat(JSON.stringify(d)).concat(DELIMITER) : d;
      stream.write(line);
    } catch (e) {
      logger.error("Could not serialize or stream data chunk: ".concat(e.toString()));
      return;
    } // Calling .flush() on a compression stream will
    // make zlib return as much output as currently possible.


    if (isCompressed) {
      stream.flush();
    }
  }

  var responseWithHeaders = _objectSpread({
    body: stream
  }, isCompressed ? {
    headers: {
      'content-encoding': 'gzip'
    }
  } : {});

  return {
    DELIMITER: DELIMITER,
    end: end,
    push: push,
    responseWithHeaders: responseWithHeaders
  };
}