"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withEuiTheme = exports.useEuiTheme = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireWildcard(require("react"));

var _context = require("./context");

var _react2 = require("@emotion/react");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var useEuiTheme = function useEuiTheme() {
  var theme = (0, _react.useContext)(_context.EuiThemeContext);
  var colorMode = (0, _react.useContext)(_context.EuiColorModeContext);
  var modifications = (0, _react.useContext)(_context.EuiModificationsContext);
  return {
    euiTheme: theme,
    colorMode: colorMode,
    modifications: modifications
  };
};

exports.useEuiTheme = useEuiTheme;

// Provide the component props interface as the generic to allow the docs props table to populate.
// e.g., `const EuiComponent = withEuiTheme<EuiComponentProps>(_EuiComponent)`
var withEuiTheme = function withEuiTheme(Component) {
  var componentName = Component.displayName || Component.name || 'ComponentWithTheme';

  var Render = function Render(props, ref) {
    var _useEuiTheme = useEuiTheme(),
        euiTheme = _useEuiTheme.euiTheme,
        colorMode = _useEuiTheme.colorMode,
        modifications = _useEuiTheme.modifications;

    return (0, _react2.jsx)(Component, (0, _extends2.default)({
      theme: {
        euiTheme: euiTheme,
        colorMode: colorMode,
        modifications: modifications
      },
      ref: ref
    }, props));
  };

  var WithEuiTheme = /*#__PURE__*/(0, _react.forwardRef)(Render);
  WithEuiTheme.displayName = componentName;
  return WithEuiTheme;
};

exports.withEuiTheme = withEuiTheme;