"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT_SIZES = exports.EuiText = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _text = require("./text.styles");

var _text_color = require("./text_color");

var _text_align = require("./text_align");

var _react2 = require("@emotion/react");

var _excluded = ["size", "color", "grow", "textAlign", "children", "className"];
var TEXT_SIZES = ['xs', 's', 'm', 'relative'];
exports.TEXT_SIZES = TEXT_SIZES;

var EuiText = function EuiText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      color = _ref.color,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      textAlign = _ref.textAlign,
      children = _ref.children,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _text.euiTextStyles)(euiTheme);
  var cssStyles = [styles.euiText, !grow ? styles.constrainedWidth : undefined, styles[size]];
  var classes = (0, _classnames.default)('euiText', className);
  var text = (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), children);

  if (color) {
    text = (0, _react2.jsx)(_text_color.EuiTextColor, {
      color: color,
      className: classes,
      cloneElement: true
    }, text);
  }

  if (textAlign) {
    text = (0, _react2.jsx)(_text_align.EuiTextAlign, {
      textAlign: textAlign,
      className: classes,
      cloneElement: true
    }, text);
  }

  return text;
};

exports.EuiText = EuiText;
EuiText.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  textAlign: _propTypes.default.any,

  /**
       * Determines the text size. Choose `relative` to control the `font-size` based on the value of a parent container.
       */
  size: _propTypes.default.any,

  /**
       * Any of our named colors or a `hex`, `rgb` or `rgba` value.
       */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  grow: _propTypes.default.bool
};