"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appendIconComponentCache = exports.TYPES = exports.SIZES = exports.EuiIcon = exports.COLORS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@emotion/react");

var _excluded = ["type", "aria-label"];

var EuiIcon = function EuiIcon(_ref) {
  var type = _ref.type,
      ariaLabel = _ref['aria-label'],
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    "data-euiicon-type": typeof type === 'string' ? type : type.displayName || type.name
  }, rest), // render aria-label as text, if it's passed in props
  ariaLabel !== null && ariaLabel !== void 0 ? ariaLabel : '');
};

exports.EuiIcon = EuiIcon;

var appendIconComponentCache = function appendIconComponentCache(_) {// manually appending to the internal EuiIcon cache is out-of-scope of this test environment
};

exports.appendIconComponentCache = appendIconComponentCache;
var TYPES = [];
exports.TYPES = TYPES;
var COLORS = [];
exports.COLORS = COLORS;
var SIZES = [];
exports.SIZES = SIZES;