"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridCellPopoverActions = exports.EuiDataGridCellActions = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireWildcard(require("react"));

var _i18n = require("../../i18n");

var _button_icon = require("../../button/button_icon");

var _button_empty = require("../../button/button_empty");

var _flex = require("../../flex");

var _popover = require("../../popover");

var _react2 = require("@emotion/react");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiDataGridCellActions = function EuiDataGridCellActions(_ref) {
  var onExpandClick = _ref.onExpandClick,
      column = _ref.column,
      rowIndex = _ref.rowIndex,
      colIndex = _ref.colIndex;
  // Note: The cell expand button/expansion popover is *always* rendered if
  // column.cellActions is present (regardless of column.isExpandable).
  // This is because cell actions are not otherwise accessible to keyboard
  // or screen reader users
  var expandButton = (0, _react2.jsx)(_i18n.EuiI18n, {
    key: 'expand',
    token: "euiDataGridCellActions.expandButtonTitle",
    default: "Click or hit enter to interact with cell content"
  }, function (expandButtonTitle) {
    return (0, _react2.jsx)(_button_icon.EuiButtonIcon, {
      display: "fill",
      className: "euiDataGridRowCell__actionButtonIcon",
      "data-test-subj": "euiDataGridCellExpandButton",
      color: "primary",
      iconSize: "s",
      iconType: "expandMini",
      "aria-hidden": true,
      onClick: onExpandClick,
      title: expandButtonTitle
    });
  });
  var additionalButtons = (0, _react.useMemo)(function () {
    if (!column || !Array.isArray(column === null || column === void 0 ? void 0 : column.cellActions)) return [];

    var ButtonComponent = function ButtonComponent(props) {
      return (0, _react2.jsx)(_button_icon.EuiButtonIcon, (0, _extends2.default)({}, props, {
        "aria-hidden": true,
        className: "euiDataGridRowCell__actionButtonIcon",
        iconSize: "s"
      }));
    };

    var _getVisibleCellAction = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
        _getVisibleCellAction2 = (0, _slicedToArray2.default)(_getVisibleCellAction, 1),
        visibleCellActions = _getVisibleCellAction2[0];

    return visibleCellActions.map(function (Action, idx) {
      // React is more permissible than the TS types indicate
      var ActionButtonElement = Action;
      return (0, _react2.jsx)(ActionButtonElement, {
        key: idx,
        rowIndex: rowIndex,
        colIndex: colIndex,
        columnId: column.id,
        Component: ButtonComponent,
        isExpanded: false
      });
    });
  }, [column, colIndex, rowIndex]);
  return (0, _react2.jsx)("div", {
    className: "euiDataGridRowCell__expandActions"
  }, [].concat((0, _toConsumableArray2.default)(additionalButtons), [expandButton]));
};

exports.EuiDataGridCellActions = EuiDataGridCellActions;

var EuiDataGridCellPopoverActions = function EuiDataGridCellPopoverActions(_ref2) {
  var rowIndex = _ref2.rowIndex,
      colIndex = _ref2.colIndex,
      column = _ref2.column;

  var _getVisibleCellAction3 = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
      _getVisibleCellAction4 = (0, _slicedToArray2.default)(_getVisibleCellAction3, 2),
      primaryActions = _getVisibleCellAction4[0],
      secondaryActions = _getVisibleCellAction4[1];

  var renderActions = (0, _react.useCallback)(function (Action, idx) {
    var ActionButtonElement = Action;
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      key: idx
    }, (0, _react2.jsx)("div", null, (0, _react2.jsx)(ActionButtonElement, {
      rowIndex: rowIndex,
      colIndex: colIndex,
      columnId: column.id,
      Component: function Component(props) {
        return (0, _react2.jsx)(_button_empty.EuiButtonEmpty, (0, _extends2.default)({}, props, {
          size: "s"
        }));
      },
      isExpanded: true
    })));
  }, [column, colIndex, rowIndex]);
  return (0, _react2.jsx)(_react.default.Fragment, null, primaryActions.length > 0 && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, primaryActions.map(renderActions))), secondaryActions.length > 0 && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    alignItems: "flexStart"
  }, secondaryActions.map(renderActions))));
}; // Util helper to separate primary actions (columns.visibleCellActions, defaults to 2)
// and secondary actions (all remaning actions)


exports.EuiDataGridCellPopoverActions = EuiDataGridCellPopoverActions;

var getVisibleCellActions = function getVisibleCellActions(cellActions) {
  var visibleCellActions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  if (!cellActions) return [[], []];
  if (cellActions.length <= visibleCellActions) return [cellActions, []];
  var primaryCellActions = cellActions.slice(0, visibleCellActions);
  var remainingCellActions = cellActions.slice(visibleCellActions);
  return [primaryCellActions, remainingCellActions];
};