"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTimelineItemIcon = void 0;

var _react = _interopRequireDefault(require("react"));

var _avatar = require("../avatar");

var _services = require("../../services");

var _timeline_item_icon = require("./timeline_item_icon.styles");

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTimelineItemIcon = function EuiTimelineItemIcon(_ref) {
  var icon = _ref.icon,
      _ref$verticalAlign = _ref.verticalAlign,
      verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
      iconAriaLabel = _ref.iconAriaLabel;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _timeline_item_icon.euiTimelineItemIconStyles)(euiTheme);
  var cssStyles = [styles.euiTimelineItemIcon, styles[verticalAlign]];
  var cssContentStyles = styles.euiTimelineItemIcon__content;
  var ariaLabel = iconAriaLabel ? iconAriaLabel : '';
  var iconRender = typeof icon === 'string' ? (0, _react2.jsx)(_avatar.EuiAvatar, {
    color: "subdued",
    name: ariaLabel,
    iconType: icon
  }) : icon;
  return (0, _react2.jsx)("div", {
    css: cssStyles
  }, (0, _react2.jsx)("div", {
    css: cssContentStyles
  }, iconRender));
};

exports.EuiTimelineItemIcon = EuiTimelineItemIcon;