"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPanelStyles = void 0;

var _react = require("@emotion/react");

var _mixins = require("../../themes/amsterdam/global_styling/mixins");

var _global_styling = require("../../global_styling");

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var _ref = process.env.NODE_ENV === "production" ? {
  name: "122lw0e-grow",
  styles: "flex-grow:1;label:grow;"
} : {
  name: "122lw0e-grow",
  styles: "flex-grow:1;label:grow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1kk7odi-euiPanel",
  styles: "flex-grow:0;label:euiPanel;"
} : {
  name: "1kk7odi-euiPanel",
  styles: "flex-grow:0;label:euiPanel;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiPanelStyles = function euiPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiPanel: _ref2,
    grow: _ref,
    hasShadow: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadow)(euiThemeContext, 'm'), ";;label:hasShadow;"),
    hasBorder: /*#__PURE__*/(0, _react.css)("border:", euiTheme.border.thin, ";;label:hasBorder;"),
    radius: {
      none: /*#__PURE__*/(0, _react.css)(";label:none;"),
      m: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";;label:m;")
    },
    // Setup interactive behavior
    isClickable: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{transition:box-shadow ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ",transform ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ";}&:enabled{display:block;width:100%;", (0, _global_styling.logicalTextAlignCSS)('left'), ";}&:hover,&:focus{", (0, _mixins.euiShadow)(euiThemeContext, 'l'), ";transform:translateY(-2px);cursor:pointer;};label:isClickable;")
  };
};

exports.euiPanelStyles = euiPanelStyles;