"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiPanel = exports.COLORS = exports.BORDER_RADII = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _global_styling = require("../../global_styling");

var _common = require("../common");

var _panel = require("./panel.style");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "paddingSize", "borderRadius", "color", "hasShadow", "hasBorder", "grow", "panelRef", "element"];
var SIZES = _global_styling.PADDING_SIZES; // Exported padding sizes and class names necessary for EuiPopover and EuiCard.
// Which currently will only maintain support for the original values until conversion.

exports.SIZES = SIZES;
var paddingSizeToClassNameMap = {
  none: null,
  s: 'paddingSmall',
  m: 'paddingMedium',
  l: 'paddingLarge'
};

var _SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);

var BORDER_RADII = ['none', 'm'];
exports.BORDER_RADII = BORDER_RADII;
var COLORS = _global_styling.BACKGROUND_COLORS;
exports.COLORS = COLORS;

var EuiPanel = function EuiPanel(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
      _ref$borderRadius = _ref.borderRadius,
      borderRadius = _ref$borderRadius === void 0 ? 'm' : _ref$borderRadius,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'plain' : _ref$color,
      _ref$hasShadow = _ref.hasShadow,
      hasShadow = _ref$hasShadow === void 0 ? true : _ref$hasShadow,
      _ref$hasBorder = _ref.hasBorder,
      hasBorder = _ref$hasBorder === void 0 ? false : _ref$hasBorder,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      panelRef = _ref.panelRef,
      element = _ref.element,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)(); // Shadows are only allowed when there's a white background (plain)

  var canHaveShadow = !hasBorder && color === 'plain';
  var canHaveBorder = color === 'plain' || color === 'transparent';
  var styles = (0, _panel.euiPanelStyles)(euiTheme);
  var cssStyles = [styles.euiPanel, grow && styles.grow, styles.radius[borderRadius], (0, _global_styling.useEuiPaddingCSS)()[paddingSize], (0, _global_styling.useEuiBackgroundColorCSS)()[color], canHaveShadow && hasShadow === true && styles.hasShadow, canHaveBorder && hasBorder === true && styles.hasBorder, rest.onClick && styles.isClickable];
  var classes = (0, _classnames.default)('euiPanel', "euiPanel--".concat(color), (0, _defineProperty2.default)({}, "euiPanel--".concat(paddingSizeToClassNameMap[paddingSize]), paddingSizeToClassNameMap[paddingSize]), className);

  if (rest.onClick && element !== 'div') {
    return (0, _react2.jsx)("button", (0, _extends2.default)({
      ref: panelRef,
      className: classes,
      css: cssStyles
    }, rest), children);
  }

  return (0, _react2.jsx)("div", (0, _extends2.default)({
    ref: panelRef,
    className: classes,
    css: cssStyles
  }, rest), children);
};

exports.EuiPanel = EuiPanel;