"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingSpinner = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../..//services");

var _loading_strings = require("./_loading_strings");

var _loading_spinner = require("./loading_spinner.styles");

var _react2 = require("@emotion/react");

var _excluded = ["size", "className", "aria-label", "color"];
var SIZES = ['s', 'm', 'l', 'xl', 'xxl'];
exports.SIZES = SIZES;

var EuiLoadingSpinner = function EuiLoadingSpinner(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      className = _ref.className,
      ariaLabel = _ref['aria-label'],
      color = _ref.color,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _loading_spinner.euiLoadingSpinnerStyles)(euiTheme, color);
  var cssStyles = [styles.euiLoadingSpinner, styles[size]];
  var classes = (0, _classnames.default)('euiLoadingSpinner', className);
  var defaultLabel = (0, _loading_strings.useLoadingAriaLabel)();
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest));
};

exports.EuiLoadingSpinner = EuiLoadingSpinner;