"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "COLORS", {
  enumerable: true,
  get: function get() {
    return _named_colors.COLORS;
  }
});
exports.clearIconComponentCache = exports.appendIconComponentCache = exports.TYPES = exports.SIZES = exports.EuiIconClass = exports.EuiIcon = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _icon_map = require("./icon_map");

var _empty = require("./assets/empty");

var _react2 = require("../../services/react");

var _services = require("../../services");

var _named_colors = require("./named_colors");

var _icon = require("./icon.styles");

var _react3 = require("@emotion/react");

var _excluded = ["type", "size", "color", "className", "tabIndex", "title", "onIconLoad", "theme", "style"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var getIsAppIcon = function getIsAppIcon(iconType) {
  if (typeof iconType !== 'string') return false;
  if (iconType === 'dataVisualizer') return true; // Special case

  if (iconType.indexOf('data:') === 0) return false; // Inline data URIs should be short-circuited for performance

  return iconType.endsWith('App') || iconType.endsWith('Job');
};

var TYPES = (0, _common.keysOf)(_icon_map.typeToPathMap);
exports.TYPES = TYPES;
var SIZES = ['original', 's', 'm', 'l', 'xl', 'xxl'];
exports.SIZES = SIZES;

function isEuiIconType(x) {
  return typeof x === 'string' && _icon_map.typeToPathMap.hasOwnProperty(x);
}

function getInitialIcon(icon) {
  if (icon == null) {
    return undefined;
  }

  if (isEuiIconType(icon)) {
    if (iconComponentCache.hasOwnProperty(icon)) {
      return iconComponentCache[icon];
    }

    return undefined;
  }

  return icon;
}

var generateId = (0, _services.htmlIdGenerator)();
var iconComponentCache = {};

var clearIconComponentCache = function clearIconComponentCache(iconType) {
  if (iconType != null) {
    delete iconComponentCache[iconType];
  } else {
    iconComponentCache = {};
  }
};

exports.clearIconComponentCache = clearIconComponentCache;

var appendIconComponentCache = function appendIconComponentCache(iconTypeToIconComponentMap) {
  for (var _iconType in iconTypeToIconComponentMap) {
    if (iconTypeToIconComponentMap.hasOwnProperty(_iconType)) {
      iconComponentCache[_iconType] = iconTypeToIconComponentMap[_iconType];
    }
  }
};

exports.appendIconComponentCache = appendIconComponentCache;

var EuiIconClass = /*#__PURE__*/function (_PureComponent) {
  (0, _inherits2.default)(EuiIconClass, _PureComponent);

  var _super = _createSuper(EuiIconClass);

  function EuiIconClass(props) {
    var _this;

    (0, _classCallCheck2.default)(this, EuiIconClass);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isMounted", true);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "loadIconComponent", function (iconType) {
      if (iconComponentCache.hasOwnProperty(iconType)) {
        // exists in cache
        _this.setState({
          isLoading: false,
          neededLoading: false,
          icon: iconComponentCache[iconType]
        });

        _this.onIconLoad();

        return;
      }

      Promise.resolve("".concat(
      /* webpackChunkName: "icon.[request]" */
      // It's important that we don't use a template string here, it
      // stops webpack from building a dynamic require context.
      // eslint-disable-next-line prefer-template
      './assets/' + _icon_map.typeToPathMap[iconType])).then(function (s) {
        return _interopRequireWildcard(require(s));
      }).then(function (_ref) {
        var icon = _ref.icon;
        iconComponentCache[iconType] = icon;
        (0, _react2.enqueueStateChange)(function () {
          if (_this.isMounted && _this.props.type === iconType) {
            _this.setState({
              icon: icon,
              iconTitle: iconType,
              isLoading: false
            }, _this.onIconLoad);
          }
        });
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onIconLoad", function () {
      var onIconLoad = _this.props.onIconLoad;

      if (onIconLoad) {
        onIconLoad();
      }
    });
    var type = props.type;
    var initialIcon = getInitialIcon(type);
    _this.state = {
      icon: initialIcon,
      iconTitle: undefined,
      isLoading: false,
      neededLoading: false
    };
    return _this;
  }

  (0, _createClass2.default)(EuiIconClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var type = this.props.type;

      if (isEuiIconType(type) && this.state.icon == null) {
        //eslint-disable-next-line react/no-did-mount-set-state
        this.setState({
          neededLoading: true,
          isLoading: true
        });
        this.loadIconComponent(type);
      } else {
        this.onIconLoad();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var type = this.props.type;

      if (type !== prevProps.type) {
        if (isEuiIconType(type)) {
          // eslint-disable-next-line react/no-did-update-set-state
          this.setState({
            neededLoading: iconComponentCache.hasOwnProperty(type),
            isLoading: true
          });
          this.loadIconComponent(type);
        } else {
          // eslint-disable-next-line react/no-did-update-set-state
          this.setState({
            icon: type,
            neededLoading: true,
            isLoading: false
          });
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.isMounted = false;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          type = _this$props.type,
          _this$props$size = _this$props.size,
          size = _this$props$size === void 0 ? 'm' : _this$props$size,
          color = _this$props.color,
          className = _this$props.className,
          tabIndex = _this$props.tabIndex,
          title = _this$props.title,
          onIconLoad = _this$props.onIconLoad,
          theme = _this$props.theme,
          style = _this$props.style,
          rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var _this$state = this.state,
          isLoading = _this$state.isLoading,
          neededLoading = _this$state.neededLoading,
          iconTitle = _this$state.iconTitle;
      var isLoaded = !isLoading && neededLoading;
      var isCustomColor = color && !(0, _named_colors.isNamedColor)(color);
      var optionalCustomStyles = isCustomColor ? _objectSpread({
        color: color
      }, style) : style; // These icons are a little special and get some extra CSS flexibility

      var isAppIcon = getIsAppIcon(type); // App color styles are only applied if no color is passed or if color="default" is passed

      var appIconHasColor = color && color !== 'default'; // The Elastic logo should be an outline in text and ghost mode

      var isElasticLogoOutline = type === 'logoElastic' && (color === 'ghost' || color === 'text');
      var classes = (0, _classnames.default)('euiIcon', className); // Emotion styles

      var styles = (0, _icon.euiIconStyles)(theme);
      var cssStyles = [styles.euiIcon, styles[size], color && (0, _named_colors.isNamedColor)(color) && styles[color], isCustomColor && styles.customColor, isElasticLogoOutline && styles.logoElasticOutline, isAppIcon && !appIconHasColor && styles.app, isLoading && styles.isLoading, !isLoading && neededLoading && styles.isLoaded];
      var icon = this.state.icon || _empty.icon; // This is a fix for IE and Edge, which ignores tabindex="-1" on an SVG, but respects
      // focusable="false".
      //   - If there's no tabindex specified, we'll default the icon to not be focusable,
      //     which is how SVGs behave in Chrome, Safari, and FF.
      //   - If tabindex is -1, then the consumer wants the icon to be focusable by JavaScript only.
      //   - If the tabindex is 0, the consumer wants the icon to be keyboard focusable.

      var focusable = tabIndex == null || tabIndex === -1 ? 'false' : 'true';

      if (typeof icon === 'string') {
        return (0, _react3.jsx)("img", (0, _extends2.default)({
          alt: title ? title : '',
          src: icon,
          className: classes,
          css: cssStyles,
          tabIndex: tabIndex
        }, rest));
      } else {
        var Svg = icon; // If it's an empty icon, or if there is no aria-label, aria-labelledby, or title it gets aria-hidden true

        var isAriaHidden = icon === _empty.icon || !(this.props['aria-label'] || this.props['aria-labelledby'] || this.props.title);
        var hideIconEmpty = isAriaHidden && {
          'aria-hidden': true
        };
        var titleId; // If no aria-label or aria-labelledby is provided but there's a title, a titleId is generated
        //  The svg aria-labelledby attribute gets this titleId
        //  The svg title element gets this titleId as an id

        if (!this.props['aria-label'] && !this.props['aria-labelledby'] && title) {
          titleId = {
            titleId: generateId()
          };
        }

        return (0, _react3.jsx)(Svg, (0, _extends2.default)({
          className: classes,
          style: optionalCustomStyles,
          css: cssStyles,
          tabIndex: tabIndex,
          focusable: focusable,
          role: "img",
          title: title,
          "data-icon-type": iconTitle,
          "data-is-loaded": isLoaded || undefined,
          "data-is-loading": isLoading || undefined
        }, titleId, rest, hideIconEmpty));
      }
    }
  }]);
  return EuiIconClass;
}(_react.PureComponent);

exports.EuiIconClass = EuiIconClass;
var EuiIcon = (0, _services.withEuiTheme)(EuiIconClass);
exports.EuiIcon = EuiIcon;