"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.MARGINS = exports.EuiHorizontalRule = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _horizontal_rule = require("./horizontal_rule.styles");

var _react2 = require("@emotion/react");

var _excluded = ["className", "size", "margin"];
var SIZES = ['full', 'half', 'quarter'];
exports.SIZES = SIZES;
var MARGINS = ['none', 'xs', 's', 'm', 'l', 'xl', 'xxl'];
exports.MARGINS = MARGINS;
var marginToClassNameMap = {
  none: null,
  xs: 'marginXSmall',
  s: 'marginSmall',
  m: 'marginMedium',
  l: 'marginLarge',
  xl: 'marginXLarge',
  xxl: 'marginXXLarge'
};

var EuiHorizontalRule = function EuiHorizontalRule(_ref) {
  var _classNames;

  var className = _ref.className,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'full' : _ref$size,
      _ref$margin = _ref.margin,
      margin = _ref$margin === void 0 ? 'l' : _ref$margin,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _horizontal_rule.euiHorizontalRuleStyles)(euiTheme);
  var classes = (0, _classnames.default)('euiHorizontalRule', (_classNames = {}, (0, _defineProperty2.default)(_classNames, "euiHorizontalRule--".concat(size), size), (0, _defineProperty2.default)(_classNames, "euiHorizontalRule--".concat(marginToClassNameMap[margin]), margin && margin !== 'none'), _classNames), className);
  var cssStyles = [styles.euiHorizontalRule, styles[size], styles[margin]];
  return (0, _react2.jsx)("hr", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest));
};

exports.EuiHorizontalRule = EuiHorizontalRule;