"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFacetButton = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _badge = require("../badge");

var _loading = require("../loading");

var _inner_text = require("../inner_text");

var _clone_element = require("../../services/theme/clone_element");

var _services = require("../../services");

var _facet_button = require("./facet_button.styles");

var _button_display = require("../button/button_display/_button_display");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "icon", "isDisabled", "isLoading", "isSelected", "quantity", "buttonRef"];

var EuiFacetButton = function EuiFacetButton(_ref) {
  var children = _ref.children,
      className = _ref.className,
      icon = _ref.icon,
      _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      _ref$isLoading = _ref.isLoading,
      isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
      _ref$isSelected = _ref.isSelected,
      isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
      quantity = _ref.quantity,
      buttonRef = _ref.buttonRef,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // If in the loading state, force disabled to true
  isDisabled = isLoading ? true : isDisabled;
  var selection = isSelected ? 'isSelected' : 'unSelected';
  var classes = (0, _classnames.default)('euiFacetButton', className);
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _facet_button.euiFacetButtonStyles)(theme);
  var cssStyles = [styles.euiFacetButton];
  var textStyles = (0, _facet_button.euiFacetButtonTextStyles)(theme);
  var cssTextStyles = [textStyles.euiFacetButton__text, textStyles[selection]];
  var quantityStyles = (0, _facet_button.euiFacetButtonQuantityStyles)();
  var cssQuantityStyles = [quantityStyles.euiFacetButton__quantity, isDisabled && quantityStyles.isDisabled];
  var iconStyles = (0, _facet_button.euiFacetButtonIconStyles)();
  var cssIconStyles = [iconStyles.euiFacetButton__icon, isDisabled && quantityStyles.isDisabled];
  var loadingSpinnerStyles = (0, _facet_button.euiFacetButtonLoadingSpinnerStyles)();
  var cssLoadingSpinnerStyles = [loadingSpinnerStyles.euiFacetButton__loadingSpinner]; // Add quantity number if provided or loading indicator

  var buttonQuantity;

  if (isLoading) {
    buttonQuantity = (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
      css: cssLoadingSpinnerStyles,
      size: "m"
    });
  } else if (typeof quantity === 'number') {
    buttonQuantity = (0, _react2.jsx)(_badge.EuiNotificationBadge, {
      css: cssQuantityStyles,
      className: "euiFacetButton__quantity",
      size: "m",
      color: !isSelected || isDisabled ? 'subdued' : 'accent'
    }, quantity);
  } // Add an icon to the button if one exists.


  var buttonIcon;

  if ( /*#__PURE__*/_react.default.isValidElement(icon)) {
    buttonIcon = (0, _clone_element.cloneElementWithCss)(icon, {
      css: cssIconStyles,
      className: 'euiFacetButton__icon'
    });
  }

  return (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    return (0, _react2.jsx)(_button_display.EuiButtonDisplay, (0, _extends2.default)({
      className: classes,
      css: cssStyles,
      element: "button",
      isDisabled: isDisabled,
      ref: buttonRef,
      title: rest['aria-label'] || innerText,
      size: "s"
    }, rest), buttonIcon, (0, _react2.jsx)("span", {
      css: cssTextStyles,
      className: "euiFacetButton__text",
      "data-text": innerText,
      ref: ref
    }, children), buttonQuantity);
  });
};

exports.EuiFacetButton = EuiFacetButton;