"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridHeaderRow = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireWildcard(require("react"));

var _data_grid_control_header_cell = require("./data_grid_control_header_cell");

var _data_grid_header_cell = require("./data_grid_header_cell");

var _react2 = require("@emotion/react");

var _excluded = ["leadingControlColumns", "trailingControlColumns", "columns", "schema", "schemaDetectors", "columnWidths", "defaultColumnWidth", "className", "setColumnWidth", "setVisibleColumns", "switchColumnPos", "headerIsInteractive", "data-test-subj"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var EuiDataGridHeaderRow = /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var _props$leadingControl = props.leadingControlColumns,
      leadingControlColumns = _props$leadingControl === void 0 ? [] : _props$leadingControl,
      _props$trailingContro = props.trailingControlColumns,
      trailingControlColumns = _props$trailingContro === void 0 ? [] : _props$trailingContro,
      columns = props.columns,
      schema = props.schema,
      schemaDetectors = props.schemaDetectors,
      columnWidths = props.columnWidths,
      defaultColumnWidth = props.defaultColumnWidth,
      className = props.className,
      setColumnWidth = props.setColumnWidth,
      setVisibleColumns = props.setVisibleColumns,
      switchColumnPos = props.switchColumnPos,
      headerIsInteractive = props.headerIsInteractive,
      _dataTestSubj = props['data-test-subj'],
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var classes = (0, _classnames.default)('euiDataGridHeader', className);
  var dataTestSubj = (0, _classnames.default)('dataGridHeader', _dataTestSubj);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    role: "row",
    ref: ref,
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (controlColumn, index) {
    return (0, _react2.jsx)(_data_grid_control_header_cell.EuiDataGridControlHeaderCell, {
      key: controlColumn.id,
      index: index,
      controlColumn: controlColumn,
      headerIsInteractive: headerIsInteractive
    });
  }), columns.map(function (column, index) {
    return (0, _react2.jsx)(_data_grid_header_cell.EuiDataGridHeaderCell, {
      key: column.id,
      column: column,
      columns: columns,
      index: index + leadingControlColumns.length,
      columnWidths: columnWidths,
      schema: schema,
      schemaDetectors: schemaDetectors,
      setColumnWidth: setColumnWidth,
      setVisibleColumns: setVisibleColumns,
      switchColumnPos: switchColumnPos,
      defaultColumnWidth: defaultColumnWidth,
      headerIsInteractive: headerIsInteractive
    });
  }), trailingControlColumns.map(function (controlColumn, index) {
    return (0, _react2.jsx)(_data_grid_control_header_cell.EuiDataGridControlHeaderCell, {
      key: controlColumn.id,
      index: index + leadingControlColumns.length + columns.length,
      controlColumn: controlColumn,
      headerIsInteractive: headerIsInteractive
    });
  }));
});
exports.EuiDataGridHeaderRow = EuiDataGridHeaderRow;
EuiDataGridHeaderRow.displayName = 'EuiDataGridHeaderRow';