"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HEADINGS = exports.EuiCallOut = exports.COLORS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../icon");

var _text = require("../text");

var _services = require("../../services");

var _panel = require("../panel");

var _title = require("../title");

var _call_out = require("./call_out.styles");

var _react2 = require("@emotion/react");

var _excluded = ["title", "color", "size", "iconType", "children", "className", "heading"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var COLORS = ['primary', 'success', 'warning', 'danger'];
exports.COLORS = COLORS;
var HEADINGS = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p'];
exports.HEADINGS = HEADINGS;
var EuiCallOut = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var title = _ref.title,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'primary' : _ref$color,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      iconType = _ref.iconType,
      children = _ref.children,
      className = _ref.className,
      _ref$heading = _ref.heading,
      heading = _ref$heading === void 0 ? 'p' : _ref$heading,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _call_out.euiCallOutStyles)(theme);
  var cssStyles = [styles.euiCallOut];
  var cssIconStyle = [styles.euiCallOut__icon];
  var cssDescriptionStyle = [styles.euiCallOut__description];
  var headerStyles = (0, _call_out.euiCallOutHeadingStyles)(theme);
  var cssHeaderStyles = [headerStyles.euiCallOutHeader, headerStyles[color]];
  var classes = (0, _classnames.default)('euiCallOut', (0, _defineProperty2.default)({}, "euiCallOut--".concat(color), color), className);
  var headerIcon;

  if (iconType) {
    headerIcon = (0, _react2.jsx)(_icon.EuiIcon, {
      css: cssIconStyle,
      type: iconType,
      size: "m",
      "aria-hidden": "true",
      color: "inherit" // forces the icon to inherit its parent color

    });
  }

  var optionalChildren;

  if (children) {
    optionalChildren = (0, _react2.jsx)(_text.EuiText, {
      css: cssDescriptionStyle,
      size: size === 's' ? 'xs' : 's',
      color: "default"
    }, children);
  }

  var header;

  if (title) {
    var H = heading;
    header = (0, _react2.jsx)(_title.EuiTitle, {
      size: size === 's' ? 'xxs' : 'xs',
      css: cssHeaderStyles
    }, (0, _react2.jsx)(H, {
      className: "euiCallOutHeader__title"
    }, headerIcon, title));
  }

  return (0, _react2.jsx)(_panel.EuiPanel, (0, _extends2.default)({
    borderRadius: "none",
    color: color,
    css: cssStyles,
    paddingSize: size === 's' ? 's' : 'm',
    className: classes,
    panelRef: ref,
    grow: false
  }, rest), header, optionalChildren);
});
exports.EuiCallOut = EuiCallOut;
EuiCallOut.displayName = 'EuiCallOut';