import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "items", "children", "gutterSize"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { EuiTimelineItem } from './timeline_item';
import { euiTimelineStyles } from './timeline.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var GUTTER_SIZES = ['m', 'l', 'xl'];
export var EuiTimeline = function EuiTimeline(_ref) {
  var className = _ref.className,
      _ref$items = _ref.items,
      items = _ref$items === void 0 ? [] : _ref$items,
      children = _ref.children,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'xl' : _ref$gutterSize,
      rest = _objectWithoutProperties(_ref, _excluded);

  var classes = classNames('euiTimeline', className);
  var euiTheme = useEuiTheme();
  var styles = euiTimelineStyles(euiTheme);
  var cssStyles = [styles.euiTimeline, styles[gutterSize]];
  return (// eslint-disable-next-line jsx-a11y/no-redundant-roles
    ___EmotionJSX("ol", _extends({
      className: classes,
      css: cssStyles,
      role: "list"
    }, rest), items.map(function (item, index) {
      return ___EmotionJSX(EuiTimelineItem, _extends({
        key: index
      }, item));
    }), children)
  );
};