import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "disabled", "checked", "isFocused", "showIcons", "prepend", "append", "allowExclusions", "onFocusBadge", "paddingSize", "role", "searchable", "textWrap"],
    _excluded2 = ["children", "className"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import classNames from 'classnames';
import React, { Component } from 'react';
import { keysOf } from '../../common';
import { EuiI18n } from '../../i18n';
import { EuiIcon } from '../../icon';
import { EuiScreenReaderOnly } from '../../accessibility';
import { EuiBadge } from '../../badge';
import { jsx as ___EmotionJSX } from "@emotion/react";

function resolveIconAndColor(checked) {
  if (!checked) {
    return {
      icon: 'empty'
    };
  }

  return checked === 'on' ? {
    icon: 'check',
    color: 'text'
  } : {
    icon: 'cross',
    color: 'text'
  };
}

var paddingSizeToClassNameMap = {
  none: null,
  s: 'euiSelectableListItem--paddingSmall'
};
export var PADDING_SIZES = keysOf(paddingSizeToClassNameMap);
// eslint-disable-next-line react/prefer-stateless-function
export var EuiSelectableListItem = /*#__PURE__*/function (_Component) {
  _inherits(EuiSelectableListItem, _Component);

  var _super = _createSuper(EuiSelectableListItem);

  function EuiSelectableListItem(props) {
    _classCallCheck(this, EuiSelectableListItem);

    return _super.call(this, props);
  }

  _createClass(EuiSelectableListItem, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          disabled = _this$props.disabled,
          checked = _this$props.checked,
          isFocused = _this$props.isFocused,
          showIcons = _this$props.showIcons,
          prepend = _this$props.prepend,
          append = _this$props.append,
          allowExclusions = _this$props.allowExclusions,
          onFocusBadge = _this$props.onFocusBadge,
          _this$props$paddingSi = _this$props.paddingSize,
          paddingSize = _this$props$paddingSi === void 0 ? 's' : _this$props$paddingSi,
          _this$props$role = _this$props.role,
          role = _this$props$role === void 0 ? 'option' : _this$props$role,
          searchable = _this$props.searchable,
          textWrap = _this$props.textWrap,
          rest = _objectWithoutProperties(_this$props, _excluded);

      var classes = classNames('euiSelectableListItem', {
        'euiSelectableListItem-isFocused': isFocused
      }, paddingSizeToClassNameMap[paddingSize], className);
      var textClasses = classNames('euiSelectableListItem__text', _defineProperty({}, "euiSelectableListItem__text--".concat(textWrap), textWrap));
      var optionIcon;

      if (showIcons) {
        var _resolveIconAndColor = resolveIconAndColor(checked),
            icon = _resolveIconAndColor.icon,
            color = _resolveIconAndColor.color;

        optionIcon = ___EmotionJSX(EuiIcon, {
          className: "euiSelectableListItem__icon",
          color: color,
          type: icon
        });
      }

      var state;
      var instruction;

      if (allowExclusions && checked === 'on') {
        state = ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.includedOption",
          default: "Selected option."
        });
        instruction = ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.includedOptionInstructions",
          default: "To exclude this option, press enter."
        });
      } else if (allowExclusions && checked === 'off') {
        state = ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.excludedOption",
          default: "Excluded option."
        });
        instruction = ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.excludedOptionInstructions",
          default: "To uncheck this option, press enter."
        });
      } else if (allowExclusions && !checked) {
        instruction = ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.unckeckedOptionInstructions",
          default: "To select this option, press enter."
        });
      }

      var isChecked = !disabled && typeof checked === 'string';

      if (!allowExclusions && isChecked) {
        state = ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.checkedOption",
          default: "Checked option."
        });
        instruction = searchable ? ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.checkedOptionInstructions",
          default: "To uncheck this option, press enter."
        }) : undefined;
      }

      var prependNode;

      if (prepend) {
        prependNode = ___EmotionJSX("span", {
          className: "euiSelectableListItem__prepend"
        }, prepend);
      }

      var appendNode;

      if (append || !!onFocusBadge) {
        var onFocusBadgeNode;
        var defaultOnFocusBadgeProps = {
          'aria-hidden': true,
          iconType: 'returnKey',
          iconSide: 'left',
          color: 'hollow'
        };

        if (onFocusBadge === true) {
          onFocusBadgeNode = ___EmotionJSX(EuiBadge, _extends({
            className: "euiSelectableListItem__onFocusBadge"
          }, defaultOnFocusBadgeProps));
        } else if (!!onFocusBadge && onFocusBadge !== false) {
          var _children = onFocusBadge.children,
              _className = onFocusBadge.className,
              restBadgeProps = _objectWithoutProperties(onFocusBadge, _excluded2);

          onFocusBadgeNode = ___EmotionJSX(EuiBadge, _extends({
            className: classNames('euiSelectableListItem__onFocusBadge', _className)
          }, defaultOnFocusBadgeProps, restBadgeProps), _children);
        } // Only display the append wrapper if append exists or isFocused


        if (append || isFocused && !disabled) {
          appendNode = ___EmotionJSX("span", {
            className: "euiSelectableListItem__append"
          }, append, " ", isFocused && !disabled ? onFocusBadgeNode : null);
        }
      }

      var instructions = (instruction || state) && ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("div", null, state || instruction ? ' - ' : null, state, state && instruction ? ' ' : null, instruction));

      return ___EmotionJSX("li", _extends({
        role: role,
        "data-test-selected": isChecked // Whether the item is checked/selected
        ,
        "aria-checked": role === 'option' ? isChecked : undefined // Whether the item is "checked"
        ,
        "aria-selected": !disabled && isFocused // Whether the item has keyboard focus per W3 spec
        ,
        className: classes,
        "aria-disabled": disabled
      }, rest), ___EmotionJSX("span", {
        className: "euiSelectableListItem__content"
      }, optionIcon, prependNode, ___EmotionJSX("span", {
        className: textClasses
      }, children, instructions), appendNode));
    }
  }]);

  return EuiSelectableListItem;
}(Component);

_defineProperty(EuiSelectableListItem, "defaultProps", {
  showIcons: true,
  onFocusBadge: true,
  textWrap: 'truncate'
});