import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["data"],
    _excluded2 = ["label", "isGroupLabel", "checked", "disabled", "prepend", "append", "ref", "key", "searchableLabel", "data"],
    _excluded3 = ["className", "options", "searchValue", "onOptionClick", "renderOption", "height", "windowProps", "rowHeight", "activeOptionIndex", "makeOptionId", "showIcons", "singleSelection", "visibleOptions", "allowExclusions", "bordered", "paddingSize", "searchable", "onFocusBadge", "listId", "setActiveOptionIndex", "aria-label", "aria-labelledby", "aria-describedby", "role", "isVirtualized", "textWrap"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { Component, memo } from 'react';
import classNames from 'classnames';
import { FixedSizeList, areEqual } from 'react-window';
import { EuiAutoSizer } from '../../auto_sizer';
import { EuiHighlight } from '../../highlight';
import { EuiSelectableListItem } from './selectable_list_item';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSelectableList = /*#__PURE__*/function (_Component) {
  _inherits(EuiSelectableList, _Component);

  var _super = _createSuper(EuiSelectableList);

  function EuiSelectableList(props) {
    var _this;

    _classCallCheck(this, EuiSelectableList);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "listRef", null);

    _defineProperty(_assertThisInitialized(_this), "listBoxRef", null);

    _defineProperty(_assertThisInitialized(_this), "setListRef", function (ref) {
      _this.listRef = ref;

      if (ref && _this.props.activeOptionIndex) {
        ref.scrollToItem(_this.props.activeOptionIndex, 'auto');
      }
    });

    _defineProperty(_assertThisInitialized(_this), "removeScrollableTabStop", function (ref) {
      // Firefox adds a tab stop for scrollable containers
      // We handle this inside so need to stop firefox from doing its thing
      if (ref) {
        ref.setAttribute('tabindex', '-1');
      }
    });

    _defineProperty(_assertThisInitialized(_this), "setListBoxRef", function (ref) {
      _this.listBoxRef = ref;
      var _this$props = _this.props,
          listId = _this$props.listId,
          searchable = _this$props.searchable,
          singleSelection = _this$props.singleSelection,
          ariaLabel = _this$props['aria-label'],
          ariaLabelledby = _this$props['aria-labelledby'],
          ariaDescribedby = _this$props['aria-describedby'];

      if (ref) {
        ref.setAttribute('id', listId);
        ref.setAttribute('role', 'listbox');

        if (searchable !== true) {
          ref.setAttribute('tabindex', '0');

          if (singleSelection !== 'always' && singleSelection !== true) {
            ref.setAttribute('aria-multiselectable', 'true');
          }
        }

        if (typeof ariaLabel === 'string') {
          ref.setAttribute('aria-label', ariaLabel);
        } else if (typeof ariaLabelledby === 'string') {
          ref.setAttribute('aria-labelledby', ariaLabelledby);
        }

        if (typeof ariaDescribedby === 'string') {
          ref.setAttribute('aria-labelledby', ariaDescribedby);
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "ListRow", /*#__PURE__*/memo(function (_ref) {
      var data = _ref.data,
          index = _ref.index,
          style = _ref.style;
      var option = data[index];

      var optionData = option.data,
          _option = _objectWithoutProperties(option, _excluded);

      var label = option.label,
          isGroupLabel = option.isGroupLabel,
          checked = option.checked,
          disabled = option.disabled,
          prepend = option.prepend,
          append = option.append,
          ref = option.ref,
          key = option.key,
          searchableLabel = option.searchableLabel,
          _data = option.data,
          optionRest = _objectWithoutProperties(option, _excluded2);

      var _this$props2 = _this.props,
          activeOptionIndex = _this$props2.activeOptionIndex,
          allowExclusions = _this$props2.allowExclusions,
          onFocusBadge = _this$props2.onFocusBadge,
          paddingSize = _this$props2.paddingSize,
          searchValue = _this$props2.searchValue,
          showIcons = _this$props2.showIcons,
          makeOptionId = _this$props2.makeOptionId,
          renderOption = _this$props2.renderOption,
          setActiveOptionIndex = _this$props2.setActiveOptionIndex,
          searchable = _this$props2.searchable,
          textWrap = _this$props2.textWrap;

      if (isGroupLabel) {
        return ___EmotionJSX("li", _extends({
          role: "presentation",
          className: "euiSelectableList__groupLabel",
          style: style // @ts-ignore complex

        }, optionRest), prepend, label, append);
      }

      var labelCount = data.filter(function (option) {
        return option.isGroupLabel;
      }).length;
      var id = makeOptionId(index);
      return ___EmotionJSX(EuiSelectableListItem, _extends({
        key: id,
        id: id,
        style: style,
        onMouseDown: function onMouseDown() {
          setActiveOptionIndex(index);
        },
        onClick: function onClick(event) {
          event.persist(); // NOTE: This is needed for React v16 backwards compatibility

          _this.onAddOrRemoveOption(option, event);
        },
        ref: ref ? ref.bind(null, index) : undefined,
        isFocused: activeOptionIndex === index,
        title: searchableLabel || label,
        checked: checked,
        disabled: disabled,
        prepend: prepend,
        append: append,
        "aria-posinset": index + 1 - labelCount,
        "aria-setsize": data.length - labelCount,
        onFocusBadge: onFocusBadge,
        allowExclusions: allowExclusions,
        showIcons: showIcons,
        paddingSize: paddingSize,
        searchable: searchable,
        textWrap: textWrap
      }, optionRest), renderOption ? renderOption( // @ts-ignore complex
      _objectSpread(_objectSpread({}, _option), optionData), _this.props.searchValue) : ___EmotionJSX(EuiHighlight, {
        search: searchValue
      }, label));
    }, areEqual));

    _defineProperty(_assertThisInitialized(_this), "onAddOrRemoveOption", function (option, event) {
      if (option.disabled) {
        return;
      }

      var _this$props3 = _this.props,
          allowExclusions = _this$props3.allowExclusions,
          options = _this$props3.options,
          _this$props3$visibleO = _this$props3.visibleOptions,
          visibleOptions = _this$props3$visibleO === void 0 ? options : _this$props3$visibleO;

      _this.props.setActiveOptionIndex(visibleOptions.findIndex(function (_ref2) {
        var label = _ref2.label;
        return label === option.label;
      }), function () {
        if (option.checked === 'on' && allowExclusions) {
          _this.onExcludeOption(option, event);
        } else if (option.checked === 'on' || option.checked === 'off') {
          _this.onRemoveOption(option, event);
        } else {
          _this.onAddOption(option, event);
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onAddOption", function (addedOption, event) {
      var _this$props4 = _this.props,
          onOptionClick = _this$props4.onOptionClick,
          options = _this$props4.options,
          singleSelection = _this$props4.singleSelection;
      var updatedOptions = options.map(function (option) {
        // if singleSelection is enabled, uncheck any selected option(s)
        var updatedOption = _objectSpread({}, option);

        if (singleSelection) {
          delete updatedOption.checked;
        } // if this is the now-selected option, check it


        if (option === addedOption) {
          updatedOption.checked = 'on';
        }

        return updatedOption;
      });
      onOptionClick(updatedOptions, event);
    });

    _defineProperty(_assertThisInitialized(_this), "onRemoveOption", function (removedOption, event) {
      var _this$props5 = _this.props,
          onOptionClick = _this$props5.onOptionClick,
          singleSelection = _this$props5.singleSelection,
          options = _this$props5.options;
      var updatedOptions = options.map(function (option) {
        var updatedOption = _objectSpread({}, option);

        if (option === removedOption && singleSelection !== 'always') {
          delete updatedOption.checked;
        }

        return updatedOption;
      });
      onOptionClick(updatedOptions, event);
    });

    _defineProperty(_assertThisInitialized(_this), "onExcludeOption", function (excludedOption, event) {
      var _this$props6 = _this.props,
          onOptionClick = _this$props6.onOptionClick,
          options = _this$props6.options;
      excludedOption.checked = 'off';
      var updatedOptions = options.map(function (option) {
        var updatedOption = _objectSpread({}, option);

        if (option === excludedOption) {
          updatedOption.checked = 'off';
        }

        return updatedOption;
      });
      onOptionClick(updatedOptions, event);
    });

    return _this;
  }

  _createClass(EuiSelectableList, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var activeOptionIndex = this.props.activeOptionIndex;

      if (this.listBoxRef && this.props.searchable !== true) {
        this.listBoxRef.setAttribute('aria-activedescendant', "".concat(this.props.makeOptionId(activeOptionIndex)));
      }

      if (this.listRef && typeof this.props.activeOptionIndex !== 'undefined') {
        this.listRef.scrollToItem(this.props.activeOptionIndex, 'auto');
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props7 = this.props,
          className = _this$props7.className,
          options = _this$props7.options,
          searchValue = _this$props7.searchValue,
          onOptionClick = _this$props7.onOptionClick,
          renderOption = _this$props7.renderOption,
          forcedHeight = _this$props7.height,
          windowProps = _this$props7.windowProps,
          rowHeight = _this$props7.rowHeight,
          activeOptionIndex = _this$props7.activeOptionIndex,
          makeOptionId = _this$props7.makeOptionId,
          showIcons = _this$props7.showIcons,
          singleSelection = _this$props7.singleSelection,
          visibleOptions = _this$props7.visibleOptions,
          allowExclusions = _this$props7.allowExclusions,
          bordered = _this$props7.bordered,
          paddingSize = _this$props7.paddingSize,
          searchable = _this$props7.searchable,
          onFocusBadge = _this$props7.onFocusBadge,
          listId = _this$props7.listId,
          setActiveOptionIndex = _this$props7.setActiveOptionIndex,
          ariaLabel = _this$props7['aria-label'],
          ariaLabelledby = _this$props7['aria-labelledby'],
          ariaDescribedby = _this$props7['aria-describedby'],
          role = _this$props7.role,
          isVirtualized = _this$props7.isVirtualized,
          textWrap = _this$props7.textWrap,
          rest = _objectWithoutProperties(_this$props7, _excluded3);

      var optionArray = visibleOptions || options;
      var heightIsFull = forcedHeight === 'full';
      var calculatedHeight = heightIsFull ? false : forcedHeight; // If calculatedHeight is still undefined, then calculate it

      if (calculatedHeight === undefined) {
        var maxVisibleOptions = 7;
        var numVisibleOptions = optionArray.length;
        var numVisibleMoreThanMax = optionArray.length > maxVisibleOptions;

        if (numVisibleMoreThanMax) {
          // Show only half of the last one to indicate there's more to scroll to
          calculatedHeight = (maxVisibleOptions - 0.5) * rowHeight;
        } else {
          calculatedHeight = numVisibleOptions * rowHeight;
        }
      }

      var classes = classNames('euiSelectableList', {
        'euiSelectableList-fullHeight': heightIsFull,
        'euiSelectableList-bordered': bordered
      }, className);
      return ___EmotionJSX("div", _extends({
        className: classes
      }, rest), isVirtualized ? ___EmotionJSX(EuiAutoSizer, {
        disableHeight: !heightIsFull
      }, function (_ref3) {
        var width = _ref3.width,
            height = _ref3.height;
        return ___EmotionJSX(FixedSizeList, _extends({
          ref: _this2.setListRef,
          outerRef: _this2.removeScrollableTabStop,
          className: "euiSelectableList__list",
          "data-skip-axe": "scrollable-region-focusable",
          width: width,
          height: calculatedHeight || height,
          itemCount: optionArray.length,
          itemData: optionArray,
          itemSize: rowHeight,
          innerElementType: "ul",
          innerRef: _this2.setListBoxRef
        }, windowProps), _this2.ListRow);
      }) : ___EmotionJSX("div", {
        className: "euiSelectableList__list",
        ref: this.removeScrollableTabStop
      }, ___EmotionJSX("ul", {
        ref: this.setListBoxRef
      }, optionArray.map(function (_, index) {
        return /*#__PURE__*/React.createElement(_this2.ListRow, {
          key: index,
          data: optionArray,
          index: index
        }, null);
      }))));
    }
  }]);

  return EuiSelectableList;
}(Component);

_defineProperty(EuiSelectableList, "defaultProps", {
  rowHeight: 32,
  searchValue: '',
  isVirtualized: true
});