import _taggedTemplateLiteral from "@babel/runtime/helpers/taggedTemplateLiteral";

var _templateObject;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css, keyframes } from '@emotion/react';
import { euiCanAnimate } from '../../global_styling';

var _loadingSpinner = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    transform: rotate(0deg);\n  }\n\n  to {\n    transform: rotate(359deg);\n  }\n"])));

var spinnerSizes = {
  s: 'm',
  m: 'base',
  l: 'l',
  xl: 'xl',
  xxl: 'xxl'
};

var spinnerColorsCSS = function spinnerColorsCSS(border, highlight) {
  return "\n    border-color: ".concat(highlight, " ").concat(border, " ").concat(border, " ").concat(border, ";\n  ");
};

export var euiLoadingSpinnerStyles = function euiLoadingSpinnerStyles(_ref, color) {
  var euiTheme = _ref.euiTheme;
  return {
    euiLoadingSpinner: /*#__PURE__*/css("flex-shrink:0;display:inline-block;border-radius:50%;border:", euiTheme.border.thick, ";", spinnerColorsCSS((color === null || color === void 0 ? void 0 : color.border) || euiTheme.colors.lightShade, (color === null || color === void 0 ? void 0 : color.highlight) || euiTheme.colors.primary), ";", euiCanAnimate, "{animation:", _loadingSpinner, " 0.6s infinite linear;};label:euiLoadingSpinner;"),
    // Sizes
    s: /*#__PURE__*/css("width:", euiTheme.size[spinnerSizes.s], ";height:", euiTheme.size[spinnerSizes.s], ";border-width:calc(", euiTheme.border.width.thin, " * 1.5);;label:s;"),
    m: /*#__PURE__*/css("width:", euiTheme.size[spinnerSizes.m], ";height:", euiTheme.size[spinnerSizes.m], ";border-width:calc(", euiTheme.border.width.thin, " * 1.5);;label:m;"),
    l: /*#__PURE__*/css("width:", euiTheme.size[spinnerSizes.l], ";height:", euiTheme.size[spinnerSizes.l], ";;label:l;"),
    xl: /*#__PURE__*/css("width:", euiTheme.size[spinnerSizes.xl], ";height:", euiTheme.size[spinnerSizes.xl], ";;label:xl;"),
    xxl: /*#__PURE__*/css("width:", euiTheme.size[spinnerSizes.xxl], ";height:", euiTheme.size[spinnerSizes.xxl], ";;label:xxl;")
  };
};