import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["size", "className", "aria-label", "color"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../..//services';
import { useLoadingAriaLabel } from './_loading_strings';
import { euiLoadingSpinnerStyles } from './loading_spinner.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['s', 'm', 'l', 'xl', 'xxl'];
export var EuiLoadingSpinner = function EuiLoadingSpinner(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      className = _ref.className,
      ariaLabel = _ref['aria-label'],
      color = _ref.color,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = useEuiTheme();
  var styles = euiLoadingSpinnerStyles(euiTheme, color);
  var cssStyles = [styles.euiLoadingSpinner, styles[size]];
  var classes = classNames('euiLoadingSpinner', className);
  var defaultLabel = useLoadingAriaLabel();
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest));
};