import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["size", "mono", "className", "aria-label"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { euiLoadingChartStyles, euiLoadingChartBarStyles, _barIndex } from './loading_chart.styles';
import { useEuiI18n } from '../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['m', 'l', 'xl'];
export var EuiLoadingChart = function EuiLoadingChart(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$mono = _ref.mono,
      mono = _ref$mono === void 0 ? false : _ref$mono,
      className = _ref.className,
      ariaLabel = _ref['aria-label'],
      rest = _objectWithoutProperties(_ref, _excluded);

  var defaultAriaLabel = useEuiI18n('euiLoadingChart.ariaLabel', 'Loading');
  var euiTheme = useEuiTheme();
  var styles = euiLoadingChartStyles(euiTheme);
  var barStyles = euiLoadingChartBarStyles(euiTheme);
  var classes = classNames('euiLoadingChart', {
    'euiLoadingChart--mono': mono
  }, className);
  var cssStyles = [styles.euiLoadingChart, styles[size]];

  var cssBarStyles = function cssBarStyles(index) {
    return [barStyles.euiLoadingChart__bar, barStyles[size], _barIndex(index, mono, euiTheme)];
  };

  var bars = [];

  for (var index = 0; index < 4; index++) {
    bars.push(___EmotionJSX("span", {
      key: index,
      css: cssBarStyles(index)
    }));
  }

  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultAriaLabel
  }, rest), bars);
};