import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useMemo, useCallback } from 'react';
import { EuiI18n } from '../../i18n';
import { EuiButtonIcon } from '../../button/button_icon';
import { EuiButtonEmpty } from '../../button/button_empty';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiPopoverFooter } from '../../popover';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridCellActions = function EuiDataGridCellActions(_ref) {
  var onExpandClick = _ref.onExpandClick,
      column = _ref.column,
      rowIndex = _ref.rowIndex,
      colIndex = _ref.colIndex;

  // Note: The cell expand button/expansion popover is *always* rendered if
  // column.cellActions is present (regardless of column.isExpandable).
  // This is because cell actions are not otherwise accessible to keyboard
  // or screen reader users
  var expandButton = ___EmotionJSX(EuiI18n, {
    key: 'expand',
    token: "euiDataGridCellActions.expandButtonTitle",
    default: "Click or hit enter to interact with cell content"
  }, function (expandButtonTitle) {
    return ___EmotionJSX(EuiButtonIcon, {
      display: "fill",
      className: "euiDataGridRowCell__actionButtonIcon",
      "data-test-subj": "euiDataGridCellExpandButton",
      color: "primary",
      iconSize: "s",
      iconType: "expandMini",
      "aria-hidden": true,
      onClick: onExpandClick,
      title: expandButtonTitle
    });
  });

  var additionalButtons = useMemo(function () {
    if (!column || !Array.isArray(column === null || column === void 0 ? void 0 : column.cellActions)) return [];

    var ButtonComponent = function ButtonComponent(props) {
      return ___EmotionJSX(EuiButtonIcon, _extends({}, props, {
        "aria-hidden": true,
        className: "euiDataGridRowCell__actionButtonIcon",
        iconSize: "s"
      }));
    };

    var _getVisibleCellAction = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
        _getVisibleCellAction2 = _slicedToArray(_getVisibleCellAction, 1),
        visibleCellActions = _getVisibleCellAction2[0];

    return visibleCellActions.map(function (Action, idx) {
      // React is more permissible than the TS types indicate
      var ActionButtonElement = Action;
      return ___EmotionJSX(ActionButtonElement, {
        key: idx,
        rowIndex: rowIndex,
        colIndex: colIndex,
        columnId: column.id,
        Component: ButtonComponent,
        isExpanded: false
      });
    });
  }, [column, colIndex, rowIndex]);
  return ___EmotionJSX("div", {
    className: "euiDataGridRowCell__expandActions"
  }, [].concat(_toConsumableArray(additionalButtons), [expandButton]));
};
export var EuiDataGridCellPopoverActions = function EuiDataGridCellPopoverActions(_ref2) {
  var rowIndex = _ref2.rowIndex,
      colIndex = _ref2.colIndex,
      column = _ref2.column;

  var _getVisibleCellAction3 = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
      _getVisibleCellAction4 = _slicedToArray(_getVisibleCellAction3, 2),
      primaryActions = _getVisibleCellAction4[0],
      secondaryActions = _getVisibleCellAction4[1];

  var renderActions = useCallback(function (Action, idx) {
    var ActionButtonElement = Action;
    return ___EmotionJSX(EuiFlexItem, {
      key: idx
    }, ___EmotionJSX("div", null, ___EmotionJSX(ActionButtonElement, {
      rowIndex: rowIndex,
      colIndex: colIndex,
      columnId: column.id,
      Component: function Component(props) {
        return ___EmotionJSX(EuiButtonEmpty, _extends({}, props, {
          size: "s"
        }));
      },
      isExpanded: true
    })));
  }, [column, colIndex, rowIndex]);
  return ___EmotionJSX(React.Fragment, null, primaryActions.length > 0 && ___EmotionJSX(EuiPopoverFooter, null, ___EmotionJSX(EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, primaryActions.map(renderActions))), secondaryActions.length > 0 && ___EmotionJSX(EuiPopoverFooter, null, ___EmotionJSX(EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    alignItems: "flexStart"
  }, secondaryActions.map(renderActions))));
}; // Util helper to separate primary actions (columns.visibleCellActions, defaults to 2)
// and secondary actions (all remaning actions)

var getVisibleCellActions = function getVisibleCellActions(cellActions) {
  var visibleCellActions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  if (!cellActions) return [[], []];
  if (cellActions.length <= visibleCellActions) return [cellActions, []];
  var primaryCellActions = cellActions.slice(0, visibleCellActions);
  var remainingCellActions = cellActions.slice(visibleCellActions);
  return [primaryCellActions, remainingCellActions];
};