import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["title", "color", "size", "iconType", "children", "className", "heading"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { forwardRef } from 'react';
import classNames from 'classnames';
import { EuiIcon } from '../icon';
import { EuiText } from '../text';
import { useEuiTheme } from '../../services';
import { EuiPanel } from '../panel';
import { EuiTitle } from '../title';
import { euiCallOutStyles, euiCallOutHeadingStyles } from './call_out.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['primary', 'success', 'warning', 'danger'];
export var HEADINGS = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p'];
export var EuiCallOut = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var title = _ref.title,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'primary' : _ref$color,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      iconType = _ref.iconType,
      children = _ref.children,
      className = _ref.className,
      _ref$heading = _ref.heading,
      heading = _ref$heading === void 0 ? 'p' : _ref$heading,
      rest = _objectWithoutProperties(_ref, _excluded);

  var theme = useEuiTheme();
  var styles = euiCallOutStyles(theme);
  var cssStyles = [styles.euiCallOut];
  var cssIconStyle = [styles.euiCallOut__icon];
  var cssDescriptionStyle = [styles.euiCallOut__description];
  var headerStyles = euiCallOutHeadingStyles(theme);
  var cssHeaderStyles = [headerStyles.euiCallOutHeader, headerStyles[color]];
  var classes = classNames('euiCallOut', _defineProperty({}, "euiCallOut--".concat(color), color), className);
  var headerIcon;

  if (iconType) {
    headerIcon = ___EmotionJSX(EuiIcon, {
      css: cssIconStyle,
      type: iconType,
      size: "m",
      "aria-hidden": "true",
      color: "inherit" // forces the icon to inherit its parent color

    });
  }

  var optionalChildren;

  if (children) {
    optionalChildren = ___EmotionJSX(EuiText, {
      css: cssDescriptionStyle,
      size: size === 's' ? 'xs' : 's',
      color: "default"
    }, children);
  }

  var header;

  if (title) {
    var H = heading;
    header = ___EmotionJSX(EuiTitle, {
      size: size === 's' ? 'xxs' : 'xs',
      css: cssHeaderStyles
    }, ___EmotionJSX(H, {
      className: "euiCallOutHeader__title"
    }, headerIcon, title));
  }

  return ___EmotionJSX(EuiPanel, _extends({
    borderRadius: "none",
    color: color,
    css: cssStyles,
    paddingSize: size === 's' ? 's' : 'm',
    className: classes,
    panelRef: ref,
    grow: false
  }, rest), header, optionalChildren);
});
EuiCallOut.displayName = 'EuiCallOut';