import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "textProps", "isLoading", "isDisabled", "iconType", "iconSize", "iconSide"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import { useEuiTheme } from '../../../services';
import { EuiLoadingSpinner } from '../../loading';
import { EuiIcon } from '../../icon';
import { euiButtonDisplayContentStyles } from './_button_display_content.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiButtonDisplayContent = function EuiButtonDisplayContent(_ref) {
  var children = _ref.children,
      textProps = _ref.textProps,
      _ref$isLoading = _ref.isLoading,
      isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
      _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      iconType = _ref.iconType,
      _ref$iconSize = _ref.iconSize,
      iconSize = _ref$iconSize === void 0 ? 'm' : _ref$iconSize,
      iconSide = _ref.iconSide,
      contentProps = _objectWithoutProperties(_ref, _excluded);

  var theme = useEuiTheme();
  var styles = euiButtonDisplayContentStyles(theme);
  var cssStyles = [styles.euiButtonDisplayContent, iconSide && styles[iconSide], isDisabled && styles.isDisabled];
  var cssSpinnerStyles = [styles.euiButtonDisplayContent__spinner];
  var cssIconStyles = [styles.euiButtonDisplayContent__icon]; // Add an icon to the button if one exists.

  var icon; // When the button is disabled the text gets gray
  // and in some buttons the background gets a light gray
  // for better contrast we want to change the border of the spinner
  // to have the same color of the text. This way we ensure the borders
  // are always visible. The default spinner color could be very light.

  var loadingSpinnerColor = isDisabled ? {
    border: 'currentColor'
  } : undefined;

  if (isLoading) {
    icon = ___EmotionJSX(EuiLoadingSpinner, {
      css: cssSpinnerStyles,
      size: iconSize,
      color: loadingSpinnerColor
    });
  } else if (iconType) {
    icon = ___EmotionJSX(EuiIcon, {
      css: cssIconStyles,
      type: iconType,
      size: iconSize,
      color: "inherit" // forces the icon to inherit its parent color

    });
  }

  var isText = typeof children === 'string';
  return ___EmotionJSX("span", _extends({}, contentProps, {
    css: cssStyles
  }), icon, isText ? ___EmotionJSX("span", textProps, children) : children);
};