function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { euiFontSize, logicalCSS, logicalTextAlignStyle } from '../../../global_styling'; // Provides a solid reset and base for handling sizing layout
// Does not include any visual styles

export var euiButtonBaseCSS = function euiButtonBaseCSS() {
  return "\n    display: inline-block;\n    appearance: none;\n    cursor: pointer;\n    ".concat(logicalTextAlignStyle('center'), ";\n    white-space: nowrap;\n    ").concat(logicalCSS('max-width', '100%'), ";\n    vertical-align: middle;\n  ");
};

var _buttonSize = function _buttonSize(size) {
  return "\n    ".concat(logicalCSS('height', size), ";\n    // prevents descenders from getting cut off\n    line-height: ").concat(size, ";\n  ");
};

var _ref = process.env.NODE_ENV === "production" ? {
  name: "15xpz7k-fullWidth",
  styles: "display:block;width:100%;label:fullWidth;"
} : {
  name: "15xpz7k-fullWidth",
  styles: "display:block;width:100%;label:fullWidth;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;"
} : {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiButtonDisplayStyles = function euiButtonDisplayStyles(euiThemeContext, minWidth) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiButtonDisplay: /*#__PURE__*/css(euiButtonBaseCSS(), ";", minWidth && logicalCSS('min-width', minWidth), ";;label:euiButtonDisplay;"),
    // States
    isDisabled: _ref2,
    fullWidth: _ref,
    // Sizes
    xs: /*#__PURE__*/css(_buttonSize(euiTheme.size.l), euiFontSize(euiThemeContext, 'xs'), ";label:xs;"),
    s: /*#__PURE__*/css(_buttonSize(euiTheme.size.xl), euiFontSize(euiThemeContext, 's'), ";label:s;"),
    m: /*#__PURE__*/css(_buttonSize(euiTheme.size.xxl), euiFontSize(euiThemeContext, 's'), ";label:m;")
  };
};