import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["element", "children", "iconType", "iconSide", "size", "isDisabled", "isLoading", "isSelected", "fullWidth", "minWidth", "contentProps", "textProps"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { forwardRef } from 'react'; // @ts-ignore module doesn't export `createElement`

import { createElement } from '@emotion/react';
import { useEuiTheme } from '../../../services';
import { euiButtonDisplayStyles } from './_button_display.styles';
import { EuiButtonDisplayContent } from './_button_display_content';
/**
 * Extends EuiButtonDisplayContentProps which provides
 * `iconType`, `iconSide`, and `textProps`
 */

import { jsx as ___EmotionJSX } from "@emotion/react";

/**
 * EuiButtonDisplay is an internal-only component used for displaying
 * any element as a button.
 */
export var EuiButtonDisplay = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var _ref$element = _ref.element,
      element = _ref$element === void 0 ? 'button' : _ref$element,
      children = _ref.children,
      iconType = _ref.iconType,
      iconSide = _ref.iconSide,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      isLoading = _ref.isLoading,
      isSelected = _ref.isSelected,
      fullWidth = _ref.fullWidth,
      minWidth = _ref.minWidth,
      contentProps = _ref.contentProps,
      textProps = _ref.textProps,
      rest = _objectWithoutProperties(_ref, _excluded);

  var buttonIsDisabled = isLoading || isDisabled;
  var minWidthPx = minWidth === 'number' ? "".concat(minWidth, "px") : minWidth;
  var theme = useEuiTheme();
  var styles = euiButtonDisplayStyles(theme, minWidthPx);
  var cssStyles = [styles.euiButtonDisplay, styles[size], fullWidth && styles.fullWidth, isDisabled && styles.isDisabled];

  var innerNode = ___EmotionJSX(EuiButtonDisplayContent, _extends({
    isLoading: isLoading,
    isDisabled: buttonIsDisabled,
    iconType: iconType,
    iconSide: iconSide,
    textProps: _objectSpread({}, textProps)
  }, contentProps), children);

  return createElement(element, _objectSpread({
    css: cssStyles,
    disabled: element === 'button' && buttonIsDisabled,
    'aria-pressed': element === 'button' ? isSelected : undefined,
    ref: ref
  }, rest), innerNode);
});
EuiButtonDisplay.displayName = 'EuiButtonDisplay';