import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isDisabled", "disabled", "href", "target", "rel", "type", "buttonRef"],
    _excluded2 = ["element", "baseClassName", "children", "className", "iconType", "iconSide", "color", "size", "fill", "isDisabled", "isLoading", "isSelected", "contentProps", "textProps", "fullWidth", "minWidth", "style"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { forwardRef } from 'react';
import classNames from 'classnames';
import { keysOf } from '../common';
import { getSecureRelForTarget } from '../../services';
import { EuiButtonContentDeprecated as EuiButtonContent } from './_button_content_deprecated';
import { validateHref } from '../../services/security/href_validator';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var colorToClassNameMap = {
  primary: '--primary',
  accent: '--accent',
  success: '--success',
  warning: '--warning',
  danger: '--danger',
  ghost: '--ghost',
  text: '--text'
};
export var COLORS = keysOf(colorToClassNameMap);
export var sizeToClassNameMap = {
  s: '--small',
  m: null
};
export var SIZES = keysOf(sizeToClassNameMap);
/**
 * Extends EuiButtonContentProps which provides
 * `iconType`, `iconSide`, and `textProps`
 */

/**
 * EuiButton is largely responsible for providing relevant props
 * and the logic for element-specific attributes
 */
export var EuiButton = function EuiButton(_ref) {
  var _isDisabled = _ref.isDisabled,
      _disabled = _ref.disabled,
      href = _ref.href,
      target = _ref.target,
      rel = _ref.rel,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'button' : _ref$type,
      buttonRef = _ref.buttonRef,
      rest = _objectWithoutProperties(_ref, _excluded);

  var isHrefValid = !href || validateHref(href);
  var disabled = _disabled || !isHrefValid;
  var isDisabled = _isDisabled || !isHrefValid;
  var buttonIsDisabled = rest.isLoading || isDisabled || disabled;
  var element = href && !isDisabled ? 'a' : 'button';
  var elementProps = {}; // Props for all elements

  elementProps = _objectSpread(_objectSpread({}, elementProps), {}, {
    isDisabled: buttonIsDisabled
  }); // Element-specific attributes

  if (element === 'button') {
    elementProps = _objectSpread(_objectSpread({}, elementProps), {}, {
      disabled: buttonIsDisabled
    });
  }

  var relObj = {};

  if (href && !buttonIsDisabled) {
    relObj.href = href;
    relObj.rel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
  } else {
    relObj.type = type;
  }

  return (// eslint-disable-next-line react/jsx-pascal-case
    ___EmotionJSX(EuiButtonDisplayDeprecated, _extends({
      element: element,
      baseClassName: "euiButton",
      ref: buttonRef
    }, elementProps, relObj, rest))
  );
};
EuiButton.displayName = 'EuiButton';

/**
 * *DEPRECATED*
 * EuiButtonDisplay is an internal-only component used for displaying
 * any element as a button.
 * NOTE: This component *must* be below EuiButton in the file and
 * EuiButton must also set a displayName for react-docgen-typescript
 * to correctly set EuiButton's docgenInfo and display a props table.
 * This component has been deprecated in favor of the new EuiButtonDisplay
 * that can be found in `src/components/button/button_display/_button_display.tsx`
 */
export var EuiButtonDisplayDeprecated = /*#__PURE__*/forwardRef(function (_ref2, ref) {
  var _ref2$element = _ref2.element,
      element = _ref2$element === void 0 ? 'button' : _ref2$element,
      baseClassName = _ref2.baseClassName,
      children = _ref2.children,
      className = _ref2.className,
      iconType = _ref2.iconType,
      _ref2$iconSide = _ref2.iconSide,
      iconSide = _ref2$iconSide === void 0 ? 'left' : _ref2$iconSide,
      _ref2$color = _ref2.color,
      color = _ref2$color === void 0 ? 'primary' : _ref2$color,
      _ref2$size = _ref2.size,
      size = _ref2$size === void 0 ? 'm' : _ref2$size,
      _ref2$fill = _ref2.fill,
      fill = _ref2$fill === void 0 ? false : _ref2$fill,
      isDisabled = _ref2.isDisabled,
      isLoading = _ref2.isLoading,
      isSelected = _ref2.isSelected,
      contentProps = _ref2.contentProps,
      textProps = _ref2.textProps,
      fullWidth = _ref2.fullWidth,
      minWidth = _ref2.minWidth,
      style = _ref2.style,
      rest = _objectWithoutProperties(_ref2, _excluded2);

  var buttonIsDisabled = isLoading || isDisabled;
  var classes = classNames(baseClassName, color && colorToClassNameMap[color] ? "".concat(baseClassName).concat(colorToClassNameMap[color]) : "".concat(baseClassName).concat(colorToClassNameMap.primary), size && sizeToClassNameMap[size] ? "".concat(baseClassName).concat(sizeToClassNameMap[size]) : null, fill && "".concat(baseClassName, "--fill"), fullWidth && "".concat(baseClassName, "--fullWidth"), buttonIsDisabled && "".concat(baseClassName, "-isDisabled"), className);
  /**
   * Not changing the content or text class names to match baseClassName yet,
   * as it is a major breaking change.
   */

  var contentClassNames = classNames('euiButton__content', contentProps && contentProps.className);
  var textClassNames = classNames('euiButton__text', textProps && textProps.className);

  var innerNode = ___EmotionJSX(EuiButtonContent, _extends({
    isLoading: isLoading,
    iconType: iconType,
    iconSide: iconSide,
    textProps: _objectSpread(_objectSpread({}, textProps), {}, {
      className: textClassNames
    })
  }, contentProps, {
    // className has to come last to override contentProps.className
    className: contentClassNames
  }), children);

  var calculatedStyle = style;

  if (minWidth !== undefined || minWidth !== null) {
    calculatedStyle = _objectSpread(_objectSpread({}, calculatedStyle), {}, {
      minWidth: minWidth
    });
  }

  return /*#__PURE__*/React.createElement(element, _objectSpread({
    className: classes,
    style: calculatedStyle,
    disabled: element === 'button' && buttonIsDisabled,
    'aria-pressed': element === 'button' ? isSelected : undefined,
    ref: ref
  }, rest), innerNode);
});
EuiButtonDisplayDeprecated.displayName = 'EuiButtonDisplay';