"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT_SIZES = exports.EuiText = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _text = require("./text.styles");

var _text_color = require("./text_color");

var _text_align = require("./text_align");

var _react2 = require("@emotion/react");

var _excluded = ["size", "color", "grow", "textAlign", "children", "className"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var TEXT_SIZES = ['xs', 's', 'm', 'relative'];
exports.TEXT_SIZES = TEXT_SIZES;

var EuiText = function EuiText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      color = _ref.color,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      textAlign = _ref.textAlign,
      children = _ref.children,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _text.euiTextStyles)(euiTheme);
  var cssStyles = [styles.euiText, !grow ? styles.constrainedWidth : undefined, styles[size]];
  var classes = (0, _classnames.default)('euiText', className);
  var text = (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), children);

  if (color) {
    text = (0, _react2.jsx)(_text_color.EuiTextColor, {
      color: color,
      className: classes,
      cloneElement: true
    }, text);
  }

  if (textAlign) {
    text = (0, _react2.jsx)(_text_align.EuiTextAlign, {
      textAlign: textAlign,
      className: classes,
      cloneElement: true
    }, text);
  }

  return text;
};

exports.EuiText = EuiText;
EuiText.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  textAlign: _propTypes.default.any,

  /**
       * Determines the text size. Choose `relative` to control the `font-size` based on the value of a parent container.
       */
  size: _propTypes.default.any,

  /**
       * Any of our named colors or a `hex`, `rgb` or `rgba` value.
       */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  grow: _propTypes.default.bool
};