var _excluded = ["children", "textAlign", "cloneElement"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { isValidElement } from 'react';
import PropTypes from "prop-types";
import { cloneElementWithCss } from '../../services/theme/clone_element';
import { euiTextAlignStyles } from './text_align.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ALIGNMENTS = ['left', 'right', 'center'];
export var EuiTextAlign = function EuiTextAlign(_ref) {
  var children = _ref.children,
      _ref$textAlign = _ref.textAlign,
      textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
      _ref$cloneElement = _ref.cloneElement,
      cloneElement = _ref$cloneElement === void 0 ? false : _ref$cloneElement,
      rest = _objectWithoutProperties(_ref, _excluded);

  var styles = euiTextAlignStyles();
  var cssStyles = [styles.euiTextAlign, styles[textAlign]];

  var props = _objectSpread({
    css: cssStyles
  }, rest);

  if ( /*#__PURE__*/isValidElement(children) && cloneElement) {
    return cloneElementWithCss(children, props);
  } else {
    return ___EmotionJSX("div", props, children);
  }
};
EuiTextAlign.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  textAlign: PropTypes.any,

  /**
       * Applies text styling to the child element instead of rendering a parent wrapper `div`.
       * Can only be used when wrapping a *single* child element/tag, and not raw text.
       */
  cloneElement: PropTypes.bool
};