function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useEffect, useRef, useState } from 'react';
import PropTypes from "prop-types";
import { EuiScreenReaderOnly } from '../screen_reader_only';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiScreenReaderLive = function EuiScreenReaderLive(_ref) {
  var children = _ref.children,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? true : _ref$isActive,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'status' : _ref$role,
      _ref$ariaLive = _ref['aria-live'],
      ariaLive = _ref$ariaLive === void 0 ? 'polite' : _ref$ariaLive,
      _ref$focusRegionOnTex = _ref.focusRegionOnTextChange,
      focusRegionOnTextChange = _ref$focusRegionOnTex === void 0 ? false : _ref$focusRegionOnTex;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      toggle = _useState2[0],
      setToggle = _useState2[1];

  var focusRef = useRef(null);
  useEffect(function () {
    setToggle(function (toggle) {
      return !toggle;
    });
  }, [children]);
  useEffect(function () {
    if (focusRef.current !== null && focusRegionOnTextChange) {
      focusRef.current.focus();
    }
  }, [toggle, focusRegionOnTextChange]);
  return (
    /**
     * Intentionally uses two persistent live regions with oscillating content updates.
     * This resolves the problem of duplicate screen reader announcements in rapid succession
     * caused by React's virtual DOM behaviour (https://github.com/nvaccess/nvda/issues/7996#issuecomment-413641709)
     *
     * Adapted from https://github.com/alphagov/accessible-autocomplete/blob/a7106f03150941fc15e6c1ceb0a90e8872fa86ef/src/status.js
     * Debouncing was not needed for this case, but could prove to be useful for future use cases.
     * See also https://github.com/AlmeroSteyn/react-aria-live and https://github.com/dequelabs/ngA11y
     * for more examples of the double region approach.
     */
    ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("div", {
      ref: focusRef,
      tabIndex: focusRegionOnTextChange ? -1 : undefined
    }, ___EmotionJSX("div", {
      role: role,
      "aria-atomic": "true" // Setting `aria-hidden` and setting `aria-live` to "off" prevents
      // double announcements from VO when `focusRegionOnTextChange` is true
      ,
      "aria-hidden": toggle ? undefined : 'true',
      "aria-live": focusRegionOnTextChange ? 'off' : ariaLive
    }, isActive && toggle ? children : ''), ___EmotionJSX("div", {
      role: role,
      "aria-atomic": "true",
      "aria-hidden": !toggle ? undefined : 'true',
      "aria-live": focusRegionOnTextChange ? 'off' : ariaLive
    }, isActive && !toggle ? children : '')))
  );
};
EuiScreenReaderLive.propTypes = {
  /**
     * Whether to make screen readers aware of the content
     */
  isActive: PropTypes.bool,

  /**
     * Content for screen readers to announce
     */
  children: PropTypes.node,

  /**
     * `role` attribute for both live regions.
     *
     * https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions#roles_with_implicit_live_region_attributes
     */
  role: PropTypes.any,

  /**
     * `aria-live` attribute for both live regions
     */
  "aria-live": PropTypes.any,

  /**
     * On `children`/text change, the region will auto-focus itself, causing screen readers
     * to automatically read out the text content. This prop should primarily be used for
     * navigation or page changes, where programmatically resetting focus location back to
     * a certain part of the page is desired.
     */
  focusRegionOnTextChange: PropTypes.bool
};