"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeRouteWrapper = void 0;

var _lib = require("../lib/lib");

var _router = require("../../../../../src/core/server/http/router");

var _common = require("../../../observability/common");

var _service_api_key = require("../lib/saved_objects/service_api_key");

var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line @kbn/eslint/no-restricted-paths


const uptimeRouteWrapper = (uptimeRoute, server) => ({ ...uptimeRoute,
  options: {
    tags: ['access:uptime-read', ...(uptimeRoute !== null && uptimeRoute !== void 0 && uptimeRoute.writeAccess ? ['access:uptime-write'] : [])]
  },
  handler: async (context, request, response) => {
    var _server$config;

    const {
      client: esClient
    } = context.core.elasticsearch;
    let savedObjectsClient;

    if ((_server$config = server.config) !== null && _server$config !== void 0 && _server$config.service) {
      savedObjectsClient = context.core.savedObjects.getClient({
        includedHiddenTypes: [_service_api_key.syntheticsServiceApiKey.name]
      });
    } else {
      savedObjectsClient = context.core.savedObjects.client;
    } // specifically needed for the synthetics service api key generation


    server.authSavedObjectsClient = savedObjectsClient;
    const isInspectorEnabled = await context.core.uiSettings.client.get(_common.enableInspectEsQueries);
    const uptimeEsClient = (0, _lib.createUptimeESClient)({
      request,
      savedObjectsClient,
      isInspectorEnabled,
      esClient: esClient.asCurrentUser
    });
    server.uptimeEsClient = uptimeEsClient;

    if (isInspectorEnabled || server.isDev) {
      _lib.inspectableEsQueriesMap.set(request, []);
    }

    const res = await uptimeRoute.handler({
      uptimeEsClient,
      savedObjectsClient,
      context,
      request,
      response,
      server
    });

    if (res instanceof _router.KibanaResponse) {
      return res;
    }

    return response.ok({
      body: { ...res,
        ...((isInspectorEnabled || server.isDev) && uptimeRoute.path !== _constants.API_URLS.DYNAMIC_SETTINGS ? {
          _inspect: _lib.inspectableEsQueriesMap.get(request)
        } : {})
      }
    });
  }
});

exports.uptimeRouteWrapper = uptimeRouteWrapper;