"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testNowMonitorRoute = void 0;

var _configSchema = require("@kbn/config-schema");

var _uuid = require("uuid");

var _constants = require("../../../common/constants");

var _synthetics_monitor = require("../../lib/saved_objects/synthetics_monitor");

var _secrets = require("../../lib/synthetics_service/utils/secrets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const testNowMonitorRoute = () => ({
  method: 'GET',
  path: _constants.API_URLS.TRIGGER_MONITOR + '/{monitorId}',
  validate: {
    params: _configSchema.schema.object({
      monitorId: _configSchema.schema.string({
        minLength: 1,
        maxLength: 1024
      })
    })
  },
  handler: async ({
    request,
    savedObjectsClient,
    response,
    server
  }) => {
    const {
      monitorId
    } = request.params;
    const monitor = await savedObjectsClient.get(_synthetics_monitor.syntheticsMonitorType, monitorId);
    const encryptedClient = server.encryptedSavedObjects.getClient();
    const monitorWithSecrets = await encryptedClient.getDecryptedAsInternalUser(_synthetics_monitor.syntheticsMonitor.name, monitorId);
    const {
      syntheticsService
    } = server;
    const testRunId = (0, _uuid.v4)();
    const errors = await syntheticsService.triggerConfigs(request, [{ ...(0, _secrets.normalizeSecrets)(monitorWithSecrets).attributes,
      ...monitor.attributes,
      id: monitorId,
      fields_under_root: true,
      fields: {
        config_id: monitorId,
        test_run_id: testRunId
      }
    }]);

    if (errors && (errors === null || errors === void 0 ? void 0 : errors.length) > 0) {
      return {
        errors,
        testRunId,
        monitorId
      };
    }

    return {
      testRunId,
      monitorId
    };
  }
});

exports.testNowMonitorRoute = testNowMonitorRoute;