"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteItemsFromArray = exports.applyBulkActionEditToRule = exports.addItemsToArray = void 0;

var _schemas = require("../../../../common/detection_engine/schemas/common/schemas");

var _invariant = require("../../../../common/utils/invariant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const addItemsToArray = (arr, items) => Array.from(new Set([...arr, ...items]));

exports.addItemsToArray = addItemsToArray;

const deleteItemsFromArray = (arr, items) => {
  const itemsSet = new Set(items);
  return arr.filter(item => !itemsSet.has(item));
};

exports.deleteItemsFromArray = deleteItemsFromArray;

const applyBulkActionEditToRule = (existingRule, action) => {
  var _rule$tags, _rule$tags2, _rule$params$index, _rule$params$index2;

  const rule = { ...existingRule,
    params: { ...existingRule.params
    }
  };

  switch (action.type) {
    // tags actions
    case _schemas.BulkActionEditType.add_tags:
      rule.tags = addItemsToArray((_rule$tags = rule.tags) !== null && _rule$tags !== void 0 ? _rule$tags : [], action.value);
      break;

    case _schemas.BulkActionEditType.delete_tags:
      rule.tags = deleteItemsFromArray((_rule$tags2 = rule.tags) !== null && _rule$tags2 !== void 0 ? _rule$tags2 : [], action.value);
      break;

    case _schemas.BulkActionEditType.set_tags:
      rule.tags = action.value;
      break;
    // index_patterns actions
    // index pattern is not present in machine learning rule type, so we throw error on it

    case _schemas.BulkActionEditType.add_index_patterns:
      (0, _invariant.invariant)(rule.params.type !== 'machine_learning', "Index patterns can't be added. Machine learning rule doesn't have index patterns property");
      rule.params.index = addItemsToArray((_rule$params$index = rule.params.index) !== null && _rule$params$index !== void 0 ? _rule$params$index : [], action.value);
      break;

    case _schemas.BulkActionEditType.delete_index_patterns:
      (0, _invariant.invariant)(rule.params.type !== 'machine_learning', "Index patterns can't be deleted. Machine learning rule doesn't have index patterns property");
      rule.params.index = deleteItemsFromArray((_rule$params$index2 = rule.params.index) !== null && _rule$params$index2 !== void 0 ? _rule$params$index2 : [], action.value);
      (0, _invariant.invariant)(rule.params.index.length !== 0, "Can't delete all index patterns. At least one index pattern must be left");
      break;

    case _schemas.BulkActionEditType.set_index_patterns:
      (0, _invariant.invariant)(rule.params.type !== 'machine_learning', "Index patterns can't be overwritten. Machine learning rule doesn't have index patterns property");
      (0, _invariant.invariant)(action.value.length !== 0, "Index patterns can't be overwritten with empty list");
      rule.params.index = action.value;
      break;
    // timeline actions

    case _schemas.BulkActionEditType.set_timeline:
      const timelineId = action.value.timeline_id.trim() || undefined;
      const timelineTitle = timelineId ? action.value.timeline_title : undefined;
      rule.params.timelineId = timelineId;
      rule.params.timelineTitle = timelineTitle;
      break;
  }

  return rule;
};

exports.applyBulkActionEditToRule = applyBulkActionEditToRule;